/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.GCMCipherLite;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

class AesGcm
extends ContentCryptoScheme {
    AesGcm() {
    }

    @Override
    String getKeyGeneratorAlgorithm() {
        return "AES";
    }

    @Override
    String getCipherAlgorithm() {
        return "AES/GCM/NoPadding";
    }

    @Override
    int getKeyLengthInBits() {
        return 256;
    }

    @Override
    int getBlockSizeInBytes() {
        return 16;
    }

    @Override
    int getIVLengthInBytes() {
        return 12;
    }

    @Override
    long getMaxPlaintextSize() {
        return 0xFFFFFFFE0L;
    }

    @Override
    int getTagLengthInBits() {
        return 128;
    }

    @Override
    String getSpecificCipherProvider() {
        return "BC";
    }

    @Override
    CipherLite createAuxillaryCipher(SecretKey cek, byte[] ivOrig, int cipherMode, Provider securityProvider, long startingBytePos) {
        byte[] iv2 = AES_CTR.adjustIV(ivOrig, startingBytePos);
        return AES_CTR.createCipherLite(cek, iv2, cipherMode, securityProvider);
    }

    @Override
    protected CipherLite newCipherLite(Cipher cipher, SecretKey cek, int cipherMode) {
        return new GCMCipherLite(cipher, cek, cipherMode);
    }
}

