/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.KeyWrapException;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.S3CryptoScheme;
import com.amazonaws.services.s3.internal.crypto.S3KeyWrapScheme;
import com.amazonaws.services.s3.internal.crypto.SecuredCEK;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsAccessor;
import com.amazonaws.services.s3.model.ExtraMaterialsDescription;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.Base64;
import com.amazonaws.util.json.Jackson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class ContentCryptoMaterial {
    private final String keyWrappingAlgorithm;
    private final CipherLite cipherLite;
    private final Map<String, String> kekMaterialsDescription;
    private final byte[] encryptedCEK;

    ContentCryptoMaterial(Map<String, String> kekMaterialsDescription, byte[] encryptedCEK, String keyWrappingAlgorithm, CipherLite cipherLite) {
        this.cipherLite = cipherLite;
        this.keyWrappingAlgorithm = keyWrappingAlgorithm;
        this.encryptedCEK = (byte[])encryptedCEK.clone();
        this.kekMaterialsDescription = kekMaterialsDescription;
    }

    String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.cipherLite.getContentCryptoScheme();
    }

    ObjectMetadata toObjectMetadata(ObjectMetadata metadata, CryptoMode mode) {
        return mode == CryptoMode.EncryptionOnly ? this.toObjectMetadataEO(metadata) : this.toObjectMetadata(metadata);
    }

    private ObjectMetadata toObjectMetadata(ObjectMetadata metadata) {
        String keyWrapAlgo;
        byte[] encryptedCEK = this.getEncryptedCEK();
        metadata.addUserMetadata("x-amz-key-v2", Base64.encodeAsString(encryptedCEK));
        byte[] iv2 = this.cipherLite.getIV();
        metadata.addUserMetadata("x-amz-iv", Base64.encodeAsString(iv2));
        metadata.addUserMetadata("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        metadata.addUserMetadata("x-amz-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            metadata.addUserMetadata("x-amz-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            metadata.addUserMetadata("x-amz-wrap-alg", keyWrapAlgo);
        }
        return metadata;
    }

    private ObjectMetadata toObjectMetadataEO(ObjectMetadata metadata) {
        byte[] encryptedCEK = this.getEncryptedCEK();
        metadata.addUserMetadata("x-amz-key", Base64.encodeAsString(encryptedCEK));
        byte[] iv2 = this.cipherLite.getIV();
        metadata.addUserMetadata("x-amz-iv", Base64.encodeAsString(iv2));
        metadata.addUserMetadata("x-amz-matdesc", this.kekMaterialDescAsJson());
        return metadata;
    }

    String toJsonString(CryptoMode mode) {
        return mode == CryptoMode.EncryptionOnly ? this.toJsonStringEO() : this.toJsonString();
    }

    private String toJsonString() {
        String keyWrapAlgo;
        HashMap<String, String> map = new HashMap<String, String>();
        byte[] encryptedCEK = this.getEncryptedCEK();
        map.put("x-amz-key-v2", Base64.encodeAsString(encryptedCEK));
        byte[] iv2 = this.cipherLite.getIV();
        map.put("x-amz-iv", Base64.encodeAsString(iv2));
        map.put("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        map.put("x-amz-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            map.put("x-amz-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            map.put("x-amz-wrap-alg", keyWrapAlgo);
        }
        return Jackson.toJsonString(map);
    }

    private String toJsonStringEO() {
        HashMap<String, String> map = new HashMap<String, String>();
        byte[] encryptedCEK = this.getEncryptedCEK();
        map.put("x-amz-key", Base64.encodeAsString(encryptedCEK));
        byte[] iv2 = this.cipherLite.getIV();
        map.put("x-amz-iv", Base64.encodeAsString(iv2));
        map.put("x-amz-matdesc", this.kekMaterialDescAsJson());
        return Jackson.toJsonString(map);
    }

    private String kekMaterialDescAsJson() {
        Map<String, String> kekMaterialDesc = this.getKEKMaterialsDescription();
        if (kekMaterialDesc == null) {
            kekMaterialDesc = Collections.emptyMap();
        }
        return Jackson.toJsonString(kekMaterialDesc);
    }

    private static Map<String, String> matdescFromJson(String json) {
        Map map = Jackson.fromJsonString(json, Map.class);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    private static SecretKey cek(byte[] cekSecured, String keyWrapAlgo, EncryptionMaterials materials, Provider securityProvider) {
        Key kek;
        if (materials.getKeyPair() != null ? (kek = materials.getKeyPair().getPrivate()) == null : (kek = materials.getSymmetricKey()) == null) {
            throw new AmazonClientException("Key encrypting key not available");
        }
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = securityProvider == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, securityProvider);
                cipher.init(4, kek);
                return (SecretKey)cipher.unwrap(cekSecured, keyWrapAlgo, 3);
            }
            Cipher cipher = securityProvider != null ? Cipher.getInstance(kek.getAlgorithm(), securityProvider) : Cipher.getInstance(kek.getAlgorithm());
            cipher.init(2, kek);
            byte[] decryptedSymmetricKeyBytes = cipher.doFinal(cekSecured);
            return new SecretKeySpec(decryptedSymmetricKeyBytes, "AES");
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to decrypt symmetric key from object metadata : " + e2.getMessage(), e2);
        }
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, boolean keyWrapExpected) {
        return ContentCryptoMaterial.fromObjectMetadata0(metadata, kekMaterialAccessor, securityProvider, null, ExtraMaterialsDescription.NONE, keyWrapExpected);
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, ExtraMaterialsDescription extra, boolean keyWrapExpected) {
        return ContentCryptoMaterial.fromObjectMetadata0(metadata, kekMaterialAccessor, securityProvider, range, extra, keyWrapExpected);
    }

    private static ContentCryptoMaterial fromObjectMetadata0(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, ExtraMaterialsDescription extra, boolean keyWrapExpected) {
        EncryptionMaterials materials;
        Map<String, String> userMeta = metadata.getUserMetadata();
        String b64key = userMeta.get("x-amz-key-v2");
        if (b64key == null && (b64key = userMeta.get("x-amz-key")) == null) {
            throw new AmazonClientException("Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode(b64key);
        byte[] iv2 = Base64.decode(userMeta.get("x-amz-iv"));
        if (cekWrapped == null || iv2 == null) {
            throw new AmazonClientException("Content encrypting key or IV not found.");
        }
        String matdescStr = userMeta.get("x-amz-matdesc");
        Map<String, String> core = ContentCryptoMaterial.matdescFromJson(matdescStr);
        Map<String, String> merged = extra == null ? core : extra.mergeInto(core);
        EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(merged);
        if (materials == null) {
            throw new AmazonClientException("Unable to retrieve the client encryption materials");
        }
        String cekAlgo = userMeta.get("x-amz-cek-alg");
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        if (isRangeGet) {
            iv2 = contentCryptoScheme.adjustIV(iv2, range[0]);
        } else {
            String s2;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s2 = userMeta.get("x-amz-tag-len")))) {
                throw new AmazonClientException("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected);
            }
        }
        String keyWrapAlgo = userMeta.get("x-amz-wrap-alg");
        if (keyWrapExpected && keyWrapAlgo == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider);
        return new ContentCryptoMaterial(merged, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv2, 2, securityProvider));
    }

    private static KeyWrapException newKeyWrapException() {
        return new KeyWrapException("Missing key-wrap for the content-encrypting-key");
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> instFile, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, boolean keyWrapExpected) {
        return ContentCryptoMaterial.fromInstructionFile0(instFile, kekMaterialAccessor, securityProvider, null, ExtraMaterialsDescription.NONE, keyWrapExpected);
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> instFile, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, ExtraMaterialsDescription extra, boolean keyWrapExpected) {
        return ContentCryptoMaterial.fromInstructionFile0(instFile, kekMaterialAccessor, securityProvider, range, extra, keyWrapExpected);
    }

    private static ContentCryptoMaterial fromInstructionFile0(Map<String, String> instFile, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, ExtraMaterialsDescription extra, boolean keyWrapExpected) {
        EncryptionMaterials materials;
        String b64key = instFile.get("x-amz-key-v2");
        if (b64key == null && (b64key = instFile.get("x-amz-key")) == null) {
            throw new AmazonClientException("Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode(b64key);
        byte[] iv2 = Base64.decode(instFile.get("x-amz-iv"));
        if (cekWrapped == null || iv2 == null) {
            throw new AmazonClientException("Necessary encryption info not found in the instruction file " + instFile);
        }
        String matdescStr = instFile.get("x-amz-matdesc");
        Map<String, String> core = ContentCryptoMaterial.matdescFromJson(matdescStr);
        Map<String, String> merged = extra == null ? core : extra.mergeInto(core);
        EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(merged);
        if (materials == null) {
            throw new AmazonClientException("Unable to retrieve the encryption materials that originally encrypted object corresponding to instruction file " + instFile);
        }
        String cekAlgo = instFile.get("x-amz-cek-alg");
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        if (isRangeGet) {
            iv2 = contentCryptoScheme.adjustIV(iv2, range[0]);
        } else {
            String s2;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s2 = instFile.get("x-amz-tag-len")))) {
                throw new AmazonClientException("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected);
            }
        }
        String keyWrapAlgo = instFile.get("x-amz-wrap-alg");
        if (keyWrapExpected && keyWrapAlgo == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider);
        return new ContentCryptoMaterial(merged, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv2, 2, securityProvider));
    }

    static String parseInstructionFile(S3Object instructionFile) {
        try {
            return ContentCryptoMaterial.convertStreamToString(instructionFile.getObjectContent());
        }
        catch (Exception e2) {
            throw new AmazonClientException("Error parsing JSON instruction file: " + e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    CipherLite getCipherLite() {
        return this.cipherLite;
    }

    Map<String, String> getKEKMaterialsDescription() {
        return this.kekMaterialsDescription;
    }

    byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }

    ContentCryptoMaterial recreate(Map<String, String> newKEKMatDesc, EncryptionMaterialsAccessor accessor, S3CryptoScheme targetScheme, Provider p2) {
        if (newKEKMatDesc.equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        EncryptionMaterials origKEK = accessor.getEncryptionMaterials(this.kekMaterialsDescription);
        EncryptionMaterials newKEK = accessor.getEncryptionMaterials(newKEKMatDesc);
        if (newKEK == null) {
            throw new AmazonClientException("No material available with the description " + newKEKMatDesc + " from the encryption material provider");
        }
        SecretKey cek = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, origKEK, p2);
        ContentCryptoMaterial output = ContentCryptoMaterial.create(cek, this.cipherLite.getIV(), newKEK, this.getContentCryptoScheme(), targetScheme, p2);
        if (Arrays.equals(output.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return output;
    }

    ContentCryptoMaterial recreate(EncryptionMaterials newKEK, EncryptionMaterialsAccessor accessor, S3CryptoScheme targetScheme, Provider p2) {
        if (newKEK.getMaterialsDescription().equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        EncryptionMaterials origKEK = accessor.getEncryptionMaterials(this.kekMaterialsDescription);
        SecretKey cek = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, origKEK, p2);
        ContentCryptoMaterial output = ContentCryptoMaterial.create(cek, this.cipherLite.getIV(), newKEK, this.getContentCryptoScheme(), targetScheme, p2);
        if (Arrays.equals(output.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return output;
    }

    static ContentCryptoMaterial create(SecretKey cek, byte[] iv2, EncryptionMaterials kekMaterials, ContentCryptoScheme contentCryptoScheme, S3CryptoScheme targetScheme, Provider provider) {
        return ContentCryptoMaterial.create0(cek, iv2, kekMaterials, contentCryptoScheme, targetScheme, provider);
    }

    static ContentCryptoMaterial create(SecretKey cek, byte[] iv2, EncryptionMaterials kekMaterials, S3CryptoScheme scheme, Provider provider) {
        return ContentCryptoMaterial.create0(cek, iv2, kekMaterials, scheme.getContentCryptoScheme(), scheme, provider);
    }

    private static ContentCryptoMaterial create0(SecretKey cek, byte[] iv2, EncryptionMaterials kekMaterials, ContentCryptoScheme contentCryptoScheme, S3CryptoScheme targetScheme, Provider provider) {
        SecuredCEK cekSecured = ContentCryptoMaterial.secureCEK(cek, kekMaterials, targetScheme.getKeyWrapScheme(), targetScheme.getSecureRandom(), provider);
        return new ContentCryptoMaterial(kekMaterials.getMaterialsDescription(), cekSecured.getEncrypted(), cekSecured.getKeyWrapAlgorithm(), contentCryptoScheme.createCipherLite(cek, iv2, 1, provider));
    }

    private static SecuredCEK secureCEK(SecretKey cek, EncryptionMaterials materials, S3KeyWrapScheme kwScheme, SecureRandom srand, Provider p2) {
        Key kek = materials.getKeyPair() != null ? materials.getKeyPair().getPublic() : materials.getSymmetricKey();
        String keyWrapAlgo = kwScheme.getKeyWrapAlgorithm(kek);
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = p2 == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, p2);
                cipher.init(3, kek, srand);
                return new SecuredCEK(cipher.wrap(cek), keyWrapAlgo);
            }
            byte[] toBeEncryptedBytes = cek.getEncoded();
            String algo = kek.getAlgorithm();
            Cipher cipher = p2 != null ? Cipher.getInstance(algo, p2) : Cipher.getInstance(algo);
            cipher.init(1, kek);
            return new SecuredCEK(cipher.doFinal(toBeEncryptedBytes), null);
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to encrypt symmetric key: " + e2.getMessage(), e2);
        }
    }
}

