/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.crypto.AesCbc;
import com.amazonaws.services.s3.internal.crypto.AesCtr;
import com.amazonaws.services.s3.internal.crypto.AesGcm;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

abstract class ContentCryptoScheme {
    static final long MAX_GCM_BLOCKS = 0xFFFFFFFEL;
    static final long MAX_GCM_BYTES = 0xFFFFFFFE0L;
    static final long MAX_CBC_BYTES = 0x10000000000000L;
    static final long MAX_CTR_BYTES = -1L;
    static final ContentCryptoScheme AES_CBC = new AesCbc();
    static final ContentCryptoScheme AES_GCM = new AesGcm();
    static final ContentCryptoScheme AES_CTR = new AesCtr();

    ContentCryptoScheme() {
    }

    abstract String getKeyGeneratorAlgorithm();

    abstract String getCipherAlgorithm();

    String getSpecificCipherProvider() {
        return null;
    }

    abstract int getKeyLengthInBits();

    abstract int getBlockSizeInBytes();

    abstract int getIVLengthInBytes();

    int getTagLengthInBits() {
        return 0;
    }

    byte[] adjustIV(byte[] iv2, long startingBytePos) {
        return iv2;
    }

    public String toString() {
        return "cipherAlgo=" + this.getCipherAlgorithm() + ", blockSizeInBytes=" + this.getBlockSizeInBytes() + ", ivLengthInBytes=" + this.getIVLengthInBytes() + ", keyGenAlgo=" + this.getKeyGeneratorAlgorithm() + ", keyLengthInBits=" + this.getKeyLengthInBits() + ", specificProvider=" + this.getSpecificCipherProvider() + ", tagLengthInBits=" + this.getTagLengthInBits();
    }

    static byte[] incrementBlocks(byte[] counter, long blockDelta) {
        if (blockDelta == 0L) {
            return counter;
        }
        if (counter == null || counter.length != 16) {
            throw new IllegalArgumentException();
        }
        if (blockDelta > 0xFFFFFFFEL) {
            throw new IllegalStateException();
        }
        ByteBuffer bb2 = ByteBuffer.allocate(8);
        for (int i2 = 12; i2 <= 15; ++i2) {
            bb2.put(i2 - 8, counter[i2]);
        }
        long val = bb2.getLong() + blockDelta;
        if (val > 0xFFFFFFFEL) {
            throw new IllegalStateException();
        }
        bb2.rewind();
        byte[] result = bb2.putLong(val).array();
        for (int i3 = 12; i3 <= 15; ++i3) {
            counter[i3] = result[i3 - 8];
        }
        return counter;
    }

    static ContentCryptoScheme fromCEKAlgo(String cekAlgo) {
        return ContentCryptoScheme.fromCEKAlgo(cekAlgo, false);
    }

    static ContentCryptoScheme fromCEKAlgo(String cekAlgo, boolean isRangeGet) {
        if (AES_GCM.getCipherAlgorithm().equals(cekAlgo)) {
            return isRangeGet ? AES_CTR : AES_GCM;
        }
        if (cekAlgo == null || AES_CBC.getCipherAlgorithm().equals(cekAlgo)) {
            return AES_CBC;
        }
        throw new UnsupportedOperationException("Unsupported content encryption scheme: " + cekAlgo);
    }

    CipherLite createCipherLite(SecretKey cek, byte[] iv2, int cipherMode, Provider securityProvider) {
        String specificProvider = this.getSpecificCipherProvider();
        try {
            Cipher cipher = specificProvider != null ? Cipher.getInstance(this.getCipherAlgorithm(), specificProvider) : (securityProvider != null ? Cipher.getInstance(this.getCipherAlgorithm(), securityProvider) : Cipher.getInstance(this.getCipherAlgorithm()));
            cipher.init(cipherMode, (Key)cek, new IvParameterSpec(iv2));
            return this.newCipherLite(cipher, cek, cipherMode);
        }
        catch (Exception e2) {
            throw e2 instanceof RuntimeException ? (RuntimeException)e2 : new AmazonClientException("Unable to build cipher: " + e2.getMessage() + "\nMake sure you have the JCE unlimited strength policy files installed and " + "configured for your JVM", e2);
        }
    }

    protected CipherLite newCipherLite(Cipher cipher, SecretKey cek, int cipherMode) {
        return new CipherLite(cipher, this, cek, cipherMode);
    }

    CipherLite createAuxillaryCipher(SecretKey cek, byte[] iv2, int cipherMode, Provider securityProvider, long startingBytePos) {
        return null;
    }

    CipherLite createCipherLite(SecretKey cek, byte[] iv2, int cipherMode) {
        return this.createCipherLite(cek, iv2, cipherMode, null);
    }

    abstract long getMaxPlaintextSize();
}

