/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.iterable;

import com.amazonaws.services.s3.iterable.S3Versions;
import com.amazonaws.services.s3.iterable.S3Versions$1;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.VersionListing;
import java.util.Iterator;

class S3Versions$VersionIterator
implements Iterator<S3VersionSummary> {
    private VersionListing currentListing = null;
    private Iterator<S3VersionSummary> currentIterator = null;
    private S3VersionSummary nextSummary = null;
    final /* synthetic */ S3Versions this$0;

    private S3Versions$VersionIterator(S3Versions s3Versions) {
        this.this$0 = s3Versions;
    }

    @Override
    public boolean hasNext() {
        this.prepareCurrentListing();
        return this.nextMatchingSummary() != null;
    }

    @Override
    public S3VersionSummary next() {
        this.prepareCurrentListing();
        S3VersionSummary returnValue = this.nextMatchingSummary();
        this.nextSummary = null;
        return returnValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private S3VersionSummary nextMatchingSummary() {
        if (this.this$0.getKey() == null || this.nextSummary != null && this.nextSummary.getKey().equals(this.this$0.getKey())) {
            return this.nextSummary;
        }
        return null;
    }

    private void prepareCurrentListing() {
        while (this.currentListing == null || !this.currentIterator.hasNext() && this.currentListing.isTruncated()) {
            if (this.currentListing == null) {
                ListVersionsRequest req = new ListVersionsRequest();
                req.setBucketName(this.this$0.getBucketName());
                if (this.this$0.getKey() != null) {
                    req.setPrefix(this.this$0.getKey());
                } else {
                    req.setPrefix(this.this$0.getPrefix());
                }
                req.setMaxResults(this.this$0.getBatchSize());
                this.currentListing = this.this$0.getS3().listVersions(req);
            } else {
                this.currentListing = this.this$0.getS3().listNextBatchOfVersions(this.currentListing);
            }
            this.currentIterator = this.currentListing.getVersionSummaries().iterator();
        }
        if (this.nextSummary == null && this.currentIterator.hasNext()) {
            this.nextSummary = this.currentIterator.next();
        }
    }

    /* synthetic */ S3Versions$VersionIterator(S3Versions x0, S3Versions$1 x1) {
        this(x0);
    }
}

