/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.transform.AbstractHandler;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class XmlResponsesSaxParser$BucketLifecycleConfigurationHandler
extends AbstractHandler {
    private final BucketLifecycleConfiguration configuration = new BucketLifecycleConfiguration(new ArrayList<BucketLifecycleConfiguration$Rule>());
    private BucketLifecycleConfiguration$Rule currentRule;
    private BucketLifecycleConfiguration$Transition currentTransition;
    private BucketLifecycleConfiguration$NoncurrentVersionTransition currentNcvTransition;

    public BucketLifecycleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        if (this.in("LifecycleConfiguration")) {
            if (name.equals("Rule")) {
                this.currentRule = new BucketLifecycleConfiguration$Rule();
            }
        } else if (this.in("LifecycleConfiguration", "Rule")) {
            if (name.equals("Transition")) {
                this.currentTransition = new BucketLifecycleConfiguration$Transition();
            } else if (name.equals("NoncurrentVersionTransition")) {
                this.currentNcvTransition = new BucketLifecycleConfiguration$NoncurrentVersionTransition();
            }
        }
    }

    @Override
    protected void doEndElement(String uri, String name, String qName) {
        if (this.in("LifecycleConfiguration")) {
            if (name.equals("Rule")) {
                this.configuration.getRules().add(this.currentRule);
                this.currentRule = null;
            }
        } else if (this.in("LifecycleConfiguration", "Rule")) {
            if (name.equals("ID")) {
                this.currentRule.setId(this.getText());
            } else if (name.equals("Prefix")) {
                this.currentRule.setPrefix(this.getText());
            } else if (name.equals("Status")) {
                this.currentRule.setStatus(this.getText());
            } else if (name.equals("Transition")) {
                this.currentRule.setTransition(this.currentTransition);
                this.currentTransition = null;
            } else if (name.equals("NoncurrentVersionTransition")) {
                this.currentRule.setNoncurrentVersionTransition(this.currentNcvTransition);
                this.currentNcvTransition = null;
            }
        } else if (this.in("LifecycleConfiguration", "Rule", "Expiration")) {
            if (name.equals("Date")) {
                this.currentRule.setExpirationDate(ServiceUtils.parseIso8601Date(this.getText()));
            } else if (name.equals("Days")) {
                this.currentRule.setExpirationInDays(Integer.parseInt(this.getText()));
            }
        } else if (this.in("LifecycleConfiguration", "Rule", "Transition")) {
            if (name.equals("StorageClass")) {
                this.currentTransition.setStorageClass(StorageClass.fromValue(this.getText()));
            } else if (name.equals("Date")) {
                this.currentTransition.setDate(ServiceUtils.parseIso8601Date(this.getText()));
            } else if (name.equals("Days")) {
                this.currentTransition.setDays(Integer.parseInt(this.getText()));
            }
        } else if (this.in("LifecycleConfiguration", "Rule", "NoncurrentVersionExpiration")) {
            if (name.equals("NoncurrentDays")) {
                this.currentRule.setNoncurrentVersionExpirationInDays(Integer.parseInt(this.getText()));
            }
        } else if (this.in("LifecycleConfiguration", "Rule", "NoncurrentVersionTransition")) {
            if (name.equals("StorageClass")) {
                this.currentNcvTransition.setStorageClass(StorageClass.fromValue(this.getText()));
            } else if (name.equals("NoncurrentDays")) {
                this.currentNcvTransition.setDays(Integer.parseInt(this.getText()));
            }
        }
    }
}

