/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PartSummary;
import com.amazonaws.services.s3.model.transform.AbstractHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser;
import org.xml.sax.Attributes;

public class XmlResponsesSaxParser$ListPartsHandler
extends AbstractHandler {
    private final PartListing result = new PartListing();
    private PartSummary currentPart;
    private Owner currentOwner;

    public PartListing getListPartsResult() {
        return this.result;
    }

    @Override
    protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        if (this.in("ListPartsResult")) {
            if (name.equals("Part")) {
                this.currentPart = new PartSummary();
            } else if (name.equals("Owner") || name.equals("Initiator")) {
                this.currentOwner = new Owner();
            }
        }
    }

    @Override
    protected void doEndElement(String uri, String name, String qName) {
        if (this.in("ListPartsResult")) {
            if (name.equals("Bucket")) {
                this.result.setBucketName(this.getText());
            } else if (name.equals("Key")) {
                this.result.setKey(this.getText());
            } else if (name.equals("UploadId")) {
                this.result.setUploadId(this.getText());
            } else if (name.equals("Owner")) {
                this.result.setOwner(this.currentOwner);
                this.currentOwner = null;
            } else if (name.equals("Initiator")) {
                this.result.setInitiator(this.currentOwner);
                this.currentOwner = null;
            } else if (name.equals("StorageClass")) {
                this.result.setStorageClass(this.getText());
            } else if (name.equals("PartNumberMarker")) {
                this.result.setPartNumberMarker(this.parseInteger(this.getText()));
            } else if (name.equals("NextPartNumberMarker")) {
                this.result.setNextPartNumberMarker(this.parseInteger(this.getText()));
            } else if (name.equals("MaxParts")) {
                this.result.setMaxParts(this.parseInteger(this.getText()));
            } else if (name.equals("EncodingType")) {
                this.result.setEncodingType(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("IsTruncated")) {
                this.result.setTruncated(Boolean.parseBoolean(this.getText()));
            } else if (name.equals("Part")) {
                this.result.getParts().add(this.currentPart);
                this.currentPart = null;
            }
        } else if (this.in("ListPartsResult", "Part")) {
            if (name.equals("PartNumber")) {
                this.currentPart.setPartNumber(Integer.parseInt(this.getText()));
            } else if (name.equals("LastModified")) {
                this.currentPart.setLastModified(ServiceUtils.parseIso8601Date(this.getText()));
            } else if (name.equals("ETag")) {
                this.currentPart.setETag(ServiceUtils.removeQuotes(this.getText()));
            } else if (name.equals("Size")) {
                this.currentPart.setSize(Long.parseLong(this.getText()));
            }
        } else if (this.in("ListPartsResult", "Owner") || this.in("ListPartsResult", "Initiator")) {
            if (name.equals("ID")) {
                this.currentOwner.setId(XmlResponsesSaxParser.access$100(this.getText()));
            } else if (name.equals("DisplayName")) {
                this.currentOwner.setDisplayName(XmlResponsesSaxParser.access$100(this.getText()));
            }
        }
    }

    private Integer parseInteger(String text) {
        text = XmlResponsesSaxParser.access$100(this.getText());
        if (text == null) {
            return null;
        }
        return Integer.parseInt(text);
    }
}

