/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$AccessControlListHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$BucketCrossOriginConfigurationHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$BucketLifecycleConfigurationHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$BucketLocationHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$BucketLoggingConfigurationHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$BucketNotificationConfigurationHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$BucketTaggingConfigurationHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$BucketVersioningConfigurationHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$BucketWebsiteConfigurationHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$CompleteMultipartUploadHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$CopyObjectResultHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$DeleteObjectsHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$InitiateMultipartUploadHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$ListAllMyBucketsHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$ListBucketHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$ListMultipartUploadsHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$ListPartsHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$ListVersionsHandler;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser$RequestPaymentConfigurationHandler;
import com.amazonaws.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlResponsesSaxParser {
    private static final Log log = LogFactory.getLog(XmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private boolean sanitizeXmlDocument = true;

    public XmlResponsesSaxParser() {
        try {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e2) {
            throw new AmazonClientException("Couldn't initialize a SAX driver to create an XMLReader", e2);
        }
    }

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Parsing XML response document with handler: " + handler.getClass());
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(breader));
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            block6: {
                try {
                    inputStream.close();
                }
                catch (IOException e3) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error("Unable to close response InputStream up after XML parse failure", e3);
                }
            }
            throw new AmazonClientException("Failed to parse XML document with handler " + handler.getClass(), t2);
        }
    }

    protected InputStream sanitizeXmlDocument(DefaultHandler handler, InputStream inputStream) {
        if (!this.sanitizeXmlDocument) {
            return inputStream;
        }
        if (log.isDebugEnabled()) {
            log.debug("Sanitizing XML document destined for handler " + handler.getClass());
        }
        ByteArrayInputStream sanitizedInputStream = null;
        try {
            StringBuilder listingDocBuffer = new StringBuilder();
            BufferedReader br2 = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            char[] buf = new char[8192];
            int read = -1;
            while ((read = br2.read(buf)) != -1) {
                listingDocBuffer.append(buf, 0, read);
            }
            br2.close();
            String listingDoc = listingDocBuffer.toString().replaceAll("\r", "&#013;");
            sanitizedInputStream = new ByteArrayInputStream(listingDoc.getBytes(StringUtils.UTF8));
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (Throwable t2) {
            block8: {
                try {
                    inputStream.close();
                }
                catch (IOException e3) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error("Unable to close response InputStream after failure sanitizing XML document", e3);
                }
            }
            throw new AmazonClientException("Failed to sanitize XML document destined for handler " + handler.getClass(), t2);
        }
        return sanitizedInputStream;
    }

    private static String checkForEmptyString(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.length() == 0) {
            return null;
        }
        return s2;
    }

    private static int parseInt(String s2) {
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException nfe) {
            log.error("Unable to parse integer value '" + s2 + "'", nfe);
            return -1;
        }
    }

    private static long parseLong(String s2) {
        try {
            return Long.parseLong(s2);
        }
        catch (NumberFormatException nfe) {
            log.error("Unable to parse long value '" + s2 + "'", nfe);
            return -1L;
        }
    }

    public XmlResponsesSaxParser$ListBucketHandler parseListBucketObjectsResponse(InputStream inputStream) {
        XmlResponsesSaxParser$ListBucketHandler handler = new XmlResponsesSaxParser$ListBucketHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public XmlResponsesSaxParser$ListVersionsHandler parseListVersionsResponse(InputStream inputStream) {
        XmlResponsesSaxParser$ListVersionsHandler handler = new XmlResponsesSaxParser$ListVersionsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public XmlResponsesSaxParser$ListAllMyBucketsHandler parseListMyBucketsResponse(InputStream inputStream) {
        XmlResponsesSaxParser$ListAllMyBucketsHandler handler = new XmlResponsesSaxParser$ListAllMyBucketsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public XmlResponsesSaxParser$AccessControlListHandler parseAccessControlListResponse(InputStream inputStream) {
        XmlResponsesSaxParser$AccessControlListHandler handler = new XmlResponsesSaxParser$AccessControlListHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$BucketLoggingConfigurationHandler parseLoggingStatusResponse(InputStream inputStream) {
        XmlResponsesSaxParser$BucketLoggingConfigurationHandler handler = new XmlResponsesSaxParser$BucketLoggingConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$BucketLifecycleConfigurationHandler parseBucketLifecycleConfigurationResponse(InputStream inputStream) {
        XmlResponsesSaxParser$BucketLifecycleConfigurationHandler handler = new XmlResponsesSaxParser$BucketLifecycleConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$BucketCrossOriginConfigurationHandler parseBucketCrossOriginConfigurationResponse(InputStream inputStream) {
        XmlResponsesSaxParser$BucketCrossOriginConfigurationHandler handler = new XmlResponsesSaxParser$BucketCrossOriginConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public String parseBucketLocationResponse(InputStream inputStream) {
        XmlResponsesSaxParser$BucketLocationHandler handler = new XmlResponsesSaxParser$BucketLocationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.getLocation();
    }

    public XmlResponsesSaxParser$BucketVersioningConfigurationHandler parseVersioningConfigurationResponse(InputStream inputStream) {
        XmlResponsesSaxParser$BucketVersioningConfigurationHandler handler = new XmlResponsesSaxParser$BucketVersioningConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$BucketWebsiteConfigurationHandler parseWebsiteConfigurationResponse(InputStream inputStream) {
        XmlResponsesSaxParser$BucketWebsiteConfigurationHandler handler = new XmlResponsesSaxParser$BucketWebsiteConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$BucketNotificationConfigurationHandler parseNotificationConfigurationResponse(InputStream inputStream) {
        XmlResponsesSaxParser$BucketNotificationConfigurationHandler handler = new XmlResponsesSaxParser$BucketNotificationConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$BucketTaggingConfigurationHandler parseTaggingConfigurationResponse(InputStream inputStream) {
        XmlResponsesSaxParser$BucketTaggingConfigurationHandler handler = new XmlResponsesSaxParser$BucketTaggingConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$DeleteObjectsHandler parseDeletedObjectsResult(InputStream inputStream) {
        XmlResponsesSaxParser$DeleteObjectsHandler handler = new XmlResponsesSaxParser$DeleteObjectsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$CopyObjectResultHandler parseCopyObjectResponse(InputStream inputStream) {
        XmlResponsesSaxParser$CopyObjectResultHandler handler = new XmlResponsesSaxParser$CopyObjectResultHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$CompleteMultipartUploadHandler parseCompleteMultipartUploadResponse(InputStream inputStream) {
        XmlResponsesSaxParser$CompleteMultipartUploadHandler handler = new XmlResponsesSaxParser$CompleteMultipartUploadHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$InitiateMultipartUploadHandler parseInitiateMultipartUploadResponse(InputStream inputStream) {
        XmlResponsesSaxParser$InitiateMultipartUploadHandler handler = new XmlResponsesSaxParser$InitiateMultipartUploadHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$ListMultipartUploadsHandler parseListMultipartUploadsResponse(InputStream inputStream) {
        XmlResponsesSaxParser$ListMultipartUploadsHandler handler = new XmlResponsesSaxParser$ListMultipartUploadsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$ListPartsHandler parseListPartsResponse(InputStream inputStream) {
        XmlResponsesSaxParser$ListPartsHandler handler = new XmlResponsesSaxParser$ListPartsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public XmlResponsesSaxParser$RequestPaymentConfigurationHandler parseRequestPaymentConfigurationResponse(InputStream inputStream) {
        XmlResponsesSaxParser$RequestPaymentConfigurationHandler handler = new XmlResponsesSaxParser$RequestPaymentConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    private static String findAttributeValue(String qnameToFind, Attributes attrs) {
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            String qname = attrs.getQName(i2);
            if (!qname.trim().equalsIgnoreCase(qnameToFind.trim())) continue;
            return attrs.getValue(i2);
        }
        return null;
    }

    static /* synthetic */ Log access$000() {
        return log;
    }

    static /* synthetic */ String access$100(String x0) {
        return XmlResponsesSaxParser.checkForEmptyString(x0);
    }

    static /* synthetic */ int access$200(String x0) {
        return XmlResponsesSaxParser.parseInt(x0);
    }

    static /* synthetic */ long access$300(String x0) {
        return XmlResponsesSaxParser.parseLong(x0);
    }

    static /* synthetic */ String access$400(String x0, Attributes x1) {
        return XmlResponsesSaxParser.findAttributeValue(x0, x1);
    }
}

