/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

public class UploadPartCallable
implements Callable<PartETag> {
    private final AmazonS3 s3;
    private final UploadPartRequest request;
    private final CountDownLatch latch;

    public UploadPartCallable(AmazonS3 s3, UploadPartRequest request, CountDownLatch latch) {
        this.s3 = s3;
        this.request = request;
        this.latch = latch;
    }

    @Override
    public PartETag call() {
        PartETag partETag = this.s3.uploadPart(this.request).getPartETag();
        this.latch.countDown();
        return partETag;
    }
}

