/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonServiceException$ErrorType;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import java.lang.reflect.Constructor;
import javax.xml.xpath.XPath;
import org.w3c.dom.Node;

public class LegacyErrorUnmarshaller
implements Unmarshaller<AmazonServiceException, Node> {
    private final Class<? extends AmazonServiceException> exceptionClass;

    public LegacyErrorUnmarshaller() {
        this(AmazonServiceException.class);
    }

    protected LegacyErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    @Override
    public AmazonServiceException unmarshall(Node in2) {
        XPath xpath = XpathUtils.xpath();
        String errorCode = this.parseErrorCode(in2, xpath);
        String message = XpathUtils.asString("Response/Errors/Error/Message", in2, xpath);
        String requestId = XpathUtils.asString("Response/RequestID", in2, xpath);
        String errorType = XpathUtils.asString("Response/Errors/Error/Type", in2, xpath);
        Constructor<? extends AmazonServiceException> constructor = this.exceptionClass.getConstructor(String.class);
        AmazonServiceException ase = constructor.newInstance(message);
        ase.setErrorCode(errorCode);
        ase.setRequestId(requestId);
        if (errorType == null) {
            ase.setErrorType(AmazonServiceException$ErrorType.Unknown);
        } else if (errorType.equalsIgnoreCase("server")) {
            ase.setErrorType(AmazonServiceException$ErrorType.Service);
        } else if (errorType.equalsIgnoreCase("client")) {
            ase.setErrorType(AmazonServiceException$ErrorType.Client);
        }
        return ase;
    }

    public String parseErrorCode(Node in2) {
        return XpathUtils.asString("Response/Errors/Error/Code", in2);
    }

    public String parseErrorCode(Node in2, XPath xpath) {
        return XpathUtils.asString("Response/Errors/Error/Code", in2, xpath);
    }

    public String getErrorPropertyPath(String property) {
        return "Response/Errors/Error/" + property;
    }
}

