/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Base16Codec$LazyHolder;
import com.amazonaws.util.Codec;
import com.amazonaws.util.CodecUtils;

class Base16Codec
implements Codec {
    private static final int OFFSET_OF_a = 87;
    private static final int OFFSET_OF_A = 55;
    private static final int MASK_4BITS = 15;
    private final byte[] ALPAHBETS = CodecUtils.toBytesDirect("0123456789ABCDEF");

    Base16Codec() {
    }

    @Override
    public byte[] encode(byte[] src) {
        byte[] dest = new byte[src.length * 2];
        int j2 = 0;
        for (int i2 = 0; i2 < src.length; ++i2) {
            int n2 = j2++;
            byte p2 = src[i2];
            dest[n2] = this.ALPAHBETS[p2 >>> 4 & 0xF];
            dest[j2++] = this.ALPAHBETS[p2 & 0xF];
        }
        return dest;
    }

    @Override
    public byte[] decode(byte[] src, int length) {
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Input is expected to be encoded in multiple of 2 bytes but found: " + length);
        }
        byte[] dest = new byte[length / 2];
        int i2 = 0;
        for (int j2 = 0; j2 < dest.length; ++j2) {
            dest[j2] = (byte)(this.pos(src[i2++]) << 4 | this.pos(src[i2++]));
        }
        return dest;
    }

    protected int pos(byte in2) {
        byte pos = Base16Codec$LazyHolder.access$000()[in2];
        if (pos > -1) {
            return pos;
        }
        throw new IllegalArgumentException("Invalid base 16 character: '" + (char)in2 + "'");
    }
}

