/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.internal.SdkFilterInputStream;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CRC32ChecksumCalculatingInputStream
extends SdkFilterInputStream {
    private CRC32 crc32 = new CRC32();

    public CRC32ChecksumCalculatingInputStream(InputStream in2) {
        super(in2);
    }

    public long getCRC32Checksum() {
        return this.crc32.getValue();
    }

    @Override
    public synchronized void reset() {
        this.abortIfNeeded();
        this.crc32.reset();
        this.in.reset();
    }

    @Override
    public int read() {
        this.abortIfNeeded();
        int ch2 = this.in.read();
        if (ch2 != -1) {
            this.crc32.update(ch2);
        }
        return ch2;
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        this.abortIfNeeded();
        int result = this.in.read(b2, off, len);
        if (result != -1) {
            this.crc32.update(b2, off, result);
        }
        return result;
    }
}

