/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.EC2MetadataClient;
import com.amazonaws.util.EC2MetadataUtils;
import com.amazonaws.util.EC2MetadataUtils$IAMSecurityCredential;
import com.amazonaws.util.EC2MetadataUtils$NetworkInterface;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EC2MetadataUtils {
    private static final String EC2_METADATA_ROOT = "/latest/meta-data";
    private static final String EC2_USERDATA_ROOT = "/latest/user-data/";
    private static final String EC2_DYNAMICDATA_ROOT = "/latest/dynamic/";
    private static final int DEFAULT_QUERY_RETRIES = 3;
    private static final int MINIMUM_RETRY_WAIT_TIME_MILLISECONDS = 250;
    private static Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private static EC2MetadataClient ec2MetadataClient = new EC2MetadataClient();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Log log;

    public static String getAmiId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ami-id");
    }

    public static String getAmiLaunchIndex() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ami-launch-index");
    }

    public static String getAmiManifestPath() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ami-manifest-path");
    }

    public static List<String> getAncestorAmiIds() {
        return EC2MetadataUtils.getItems("/latest/meta-data/ancestor-ami-ids");
    }

    public static String getInstanceAction() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/instance-action");
    }

    public static String getInstanceId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/instance-id");
    }

    public static String getInstanceType() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/instance-type");
    }

    public static String getLocalHostName() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/local-hostname");
    }

    public static String getMacAddress() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/mac");
    }

    public static String getPrivateIpAddress() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/local-ipv4");
    }

    public static String getAvailabilityZone() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/placement/availability-zone");
    }

    public static List<String> getProductCodes() {
        return EC2MetadataUtils.getItems("/latest/meta-data/product-codes");
    }

    public static String getPublicKey() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/public-keys/0/openssh-key");
    }

    public static String getRamdiskId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ramdisk-id");
    }

    public static String getReservationId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/reservation-id");
    }

    public static List<String> getSecurityGroups() {
        return EC2MetadataUtils.getItems("/latest/meta-data/security-groups");
    }

    public static IAMInfo getIAMInstanceProfileInfo() {
        String json = EC2MetadataUtils.getData("/latest/meta-data/iam/info");
        if (null == json) {
            return null;
        }
        try {
            return mapper.readValue(json, IAMInfo.class);
        }
        catch (Exception e2) {
            log.warn("Unable to parse IAM Instance profile info (" + json + "): " + e2.getMessage(), e2);
            return null;
        }
    }

    public static InstanceInfo getInstanceInfo() {
        String json = EC2MetadataUtils.getData("/latest/dynamic/instance-identity/document");
        if (null == json) {
            return null;
        }
        try {
            InstanceInfo instanceInfo = Jackson.fromJsonString(json, InstanceInfo.class);
            return instanceInfo;
        }
        catch (Exception e2) {
            log.warn("Unable to parse dynamic EC2 instance info (" + json + ") : " + e2.getMessage(), e2);
            return null;
        }
    }

    public static Map<String, EC2MetadataUtils$IAMSecurityCredential> getIAMSecurityCredentials() {
        HashMap<String, EC2MetadataUtils$IAMSecurityCredential> credentialsInfoMap = new HashMap<String, EC2MetadataUtils$IAMSecurityCredential>();
        List<String> credentials = EC2MetadataUtils.getItems("/latest/meta-data/iam/security-credentials");
        if (null != credentials) {
            for (String credential : credentials) {
                String json = EC2MetadataUtils.getData("/latest/meta-data/iam/security-credentials/" + credential);
                try {
                    EC2MetadataUtils$IAMSecurityCredential credentialInfo = mapper.readValue(json, EC2MetadataUtils$IAMSecurityCredential.class);
                    credentialsInfoMap.put(credential, credentialInfo);
                }
                catch (Exception e2) {
                    log.warn("Unable to process the credential (" + credential + "). " + e2.getMessage(), e2);
                }
            }
        }
        return credentialsInfoMap;
    }

    public static Map<String, String> getBlockDeviceMapping() {
        HashMap<String, String> blockDeviceMapping = new HashMap<String, String>();
        List<String> devices = EC2MetadataUtils.getItems("/latest/meta-data/block-device-mapping");
        for (String device : devices) {
            blockDeviceMapping.put(device, EC2MetadataUtils.getData("/latest/meta-data/block-device-mapping/" + device));
        }
        return blockDeviceMapping;
    }

    public static List<EC2MetadataUtils$NetworkInterface> getNetworkInterfaces() {
        LinkedList<EC2MetadataUtils$NetworkInterface> networkInterfaces = new LinkedList<EC2MetadataUtils$NetworkInterface>();
        List<String> macs = EC2MetadataUtils.getItems("/latest/meta-data/network/interfaces/macs/");
        for (String mac : macs) {
            String key = mac.trim();
            if (key.endsWith("/")) {
                key = key.substring(0, key.length() - 1);
            }
            networkInterfaces.add(new EC2MetadataUtils$NetworkInterface(key));
        }
        return networkInterfaces;
    }

    public static String getUserData() {
        return EC2MetadataUtils.getData(EC2_USERDATA_ROOT);
    }

    public static String getData(String path) {
        return EC2MetadataUtils.getData(path, 3);
    }

    public static String getData(String path, int tries) {
        List<String> items = EC2MetadataUtils.getItems(path, tries, true);
        if (null != items && items.size() > 0) {
            return items.get(0);
        }
        return null;
    }

    public static List<String> getItems(String path) {
        return EC2MetadataUtils.getItems(path, 3, false);
    }

    public static List<String> getItems(String path, int tries) {
        return EC2MetadataUtils.getItems(path, tries, false);
    }

    private static List<String> getItems(String path, int tries, boolean slurp) {
        if (tries == 0) {
            throw new AmazonClientException("Unable to contact EC2 metadata service.");
        }
        try {
            String response = ec2MetadataClient.readResource(path);
            List<String> items = slurp ? Collections.singletonList(response) : Arrays.asList(response.split("\n"));
            return items;
        }
        catch (AmazonClientException ace2) {
            log.warn("Unable to retrieve the requested metadata.");
            return null;
        }
        catch (Exception e2) {
            int pause = (int)(Math.pow(2.0, 3 - tries) * 250.0);
            try {
                Thread.sleep(pause < 250 ? 250L : (long)pause);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
            return EC2MetadataUtils.getItems(path, tries - 1, slurp);
        }
    }

    private static String fetchData(String path) {
        return EC2MetadataUtils.fetchData(path, false);
    }

    private static String fetchData(String path, boolean force) {
        try {
            if (force || !cache.containsKey(path)) {
                cache.put(path, EC2MetadataUtils.getData(path));
            }
            return cache.get(path);
        }
        catch (Exception e2) {
            return null;
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setPropertyNamingStrategy(fY.PASCAL_CASE_TO_CAMEL_CASE);
        log = LogFactory.getLog(EC2MetadataUtils.class);
    }
}

