/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.util.NamespaceRemovingInputStream$StringPrefixSlicer;
import java.io.BufferedInputStream;
import java.io.InputStream;

class NamespaceRemovingInputStream
extends SdkFilterInputStream {
    private byte[] lookAheadData = new byte[200];
    private boolean hasRemovedNamespace = false;

    public NamespaceRemovingInputStream(InputStream in2) {
        super(new BufferedInputStream(in2));
    }

    @Override
    public int read() {
        this.abortIfNeeded();
        int b2 = this.in.read();
        if (b2 == 120 && !this.hasRemovedNamespace) {
            this.lookAheadData[0] = (byte)b2;
            this.in.mark(this.lookAheadData.length);
            int bytesRead = this.in.read(this.lookAheadData, 1, this.lookAheadData.length - 1);
            this.in.reset();
            String string = new String(this.lookAheadData, 0, bytesRead + 1);
            int numberCharsMatched = this.matchXmlNamespaceAttribute(string);
            if (numberCharsMatched > 0) {
                for (int i2 = 0; i2 < numberCharsMatched - 1; ++i2) {
                    this.in.read();
                }
                b2 = this.in.read();
                this.hasRemovedNamespace = true;
            }
        }
        return b2;
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            int j2 = this.read();
            if (j2 == -1) {
                if (i2 == 0) {
                    return -1;
                }
                return i2;
            }
            b2[i2 + off] = (byte)j2;
        }
        return len;
    }

    @Override
    public int read(byte[] b2) {
        return this.read(b2, 0, b2.length);
    }

    private int matchXmlNamespaceAttribute(String s2) {
        NamespaceRemovingInputStream$StringPrefixSlicer stringSlicer = new NamespaceRemovingInputStream$StringPrefixSlicer(s2);
        if (!stringSlicer.removePrefix("xmlns")) {
            return -1;
        }
        stringSlicer.removeRepeatingPrefix(" ");
        if (!stringSlicer.removePrefix("=")) {
            return -1;
        }
        stringSlicer.removeRepeatingPrefix(" ");
        if (!stringSlicer.removePrefix("\"")) {
            return -1;
        }
        if (!stringSlicer.removePrefixEndingWith("\"")) {
            return -1;
        }
        return s2.length() - stringSlicer.getString().length();
    }
}

