/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import com.amazonaws.util.json.JSONTokener;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class JSONArray {
    private ArrayList myArrayList = new ArrayList();

    public JSONArray() {
    }

    public JSONArray(JSONTokener x2) {
        this();
        char q2;
        char c2 = x2.nextClean();
        if (c2 == '[') {
            q2 = ']';
        } else if (c2 == '(') {
            q2 = ')';
        } else {
            throw x2.syntaxError("A JSONArray text must start with '['");
        }
        if (x2.nextClean() == ']') {
            return;
        }
        x2.back();
        block4: while (true) {
            if (x2.nextClean() == ',') {
                x2.back();
                this.myArrayList.add(null);
            } else {
                x2.back();
                this.myArrayList.add(x2.nextValue());
            }
            c2 = x2.nextClean();
            switch (c2) {
                case ',': 
                case ';': {
                    if (x2.nextClean() == ']') {
                        return;
                    }
                    x2.back();
                    continue block4;
                }
                case ')': 
                case ']': {
                    if (q2 != c2) {
                        throw x2.syntaxError("Expected a '" + Character.valueOf(q2) + "'");
                    }
                    return;
                }
            }
            break;
        }
        throw x2.syntaxError("Expected a ',' or ']'");
    }

    public JSONArray(String source) {
        this(new JSONTokener(source));
    }

    public JSONArray(Collection collection) {
        if (collection != null) {
            for (Object o2 : collection) {
                this.myArrayList.add(JSONObject.wrap(o2));
            }
        }
    }

    public JSONArray(Object array) {
        this();
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int i2 = 0; i2 < length; ++i2) {
                this.put(JSONObject.wrap(Array.get(array, i2)));
            }
        } else {
            throw new JSONException("JSONArray initial value should be a string or collection or array.");
        }
    }

    public Object get(int index) {
        Object o2 = this.opt(index);
        if (o2 == null) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        return o2;
    }

    public boolean getBoolean(int index) {
        Object o2 = this.get(index);
        if (o2.equals(Boolean.FALSE) || o2 instanceof String && ((String)o2).equalsIgnoreCase("false")) {
            return false;
        }
        if (o2.equals(Boolean.TRUE) || o2 instanceof String && ((String)o2).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONArray[" + index + "] is not a Boolean.");
    }

    public double getDouble(int index) {
        Object o2 = this.get(index);
        try {
            return o2 instanceof Number ? ((Number)o2).doubleValue() : Double.valueOf((String)o2).doubleValue();
        }
        catch (Exception e2) {
            throw new JSONException("JSONArray[" + index + "] is not a number.");
        }
    }

    public int getInt(int index) {
        Object o2 = this.get(index);
        return o2 instanceof Number ? ((Number)o2).intValue() : (int)this.getDouble(index);
    }

    public JSONArray getJSONArray(int index) {
        Object o2 = this.get(index);
        if (o2 instanceof JSONArray) {
            return (JSONArray)o2;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index) {
        Object o2 = this.get(index);
        if (o2 instanceof JSONObject) {
            return (JSONObject)o2;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public long getLong(int index) {
        Object o2 = this.get(index);
        return o2 instanceof Number ? ((Number)o2).longValue() : (long)this.getDouble(index);
    }

    public String getString(int index) {
        return this.get(index).toString();
    }

    public boolean isNull(int index) {
        return JSONObject.NULL.equals(this.opt(index));
    }

    public String join(String separator) {
        int len = this.length();
        StringBuffer sb2 = new StringBuffer();
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 > 0) {
                sb2.append(separator);
            }
            sb2.append(JSONObject.valueToString(this.myArrayList.get(i2)));
        }
        return sb2.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int index) {
        return index < 0 || index >= this.length() ? null : this.myArrayList.get(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(int index) {
        Object o2 = this.opt(index);
        return o2 instanceof JSONArray ? (JSONArray)o2 : null;
    }

    public JSONObject optJSONObject(int index) {
        Object o2 = this.opt(index);
        return o2 instanceof JSONObject ? (JSONObject)o2 : null;
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o2 = this.opt(index);
        return o2 != null ? o2.toString() : defaultValue;
    }

    public JSONArray put(boolean value) {
        this.put(value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(Collection value) {
        this.put(new JSONArray(value));
        return this;
    }

    public JSONArray put(double value) {
        Double d2 = new Double(value);
        JSONObject.testValidity(d2);
        this.put(d2);
        return this;
    }

    public JSONArray put(int value) {
        this.put((Object)value);
        return this;
    }

    public JSONArray put(long value) {
        this.put((Object)value);
        return this;
    }

    public JSONArray put(Map value) {
        this.put(new JSONObject(value));
        return this;
    }

    public JSONArray put(Object value) {
        this.myArrayList.add(value);
        return this;
    }

    public JSONArray put(int index, boolean value) {
        this.put(index, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(int index, Collection value) {
        this.put(index, new JSONArray(value));
        return this;
    }

    public JSONArray put(int index, double value) {
        this.put(index, new Double(value));
        return this;
    }

    public JSONArray put(int index, int value) {
        this.put(index, (Object)value);
        return this;
    }

    public JSONArray put(int index, long value) {
        this.put(index, (Object)value);
        return this;
    }

    public JSONArray put(int index, Map value) {
        this.put(index, new JSONObject(value));
        return this;
    }

    public JSONArray put(int index, Object value) {
        JSONObject.testValidity(value);
        if (index < 0) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.length()) {
            this.myArrayList.set(index, value);
        } else {
            while (index != this.length()) {
                this.put(JSONObject.NULL);
            }
            this.put(value);
        }
        return this;
    }

    public Object remove(int index) {
        Object o2 = this.opt(index);
        this.myArrayList.remove(index);
        return o2;
    }

    public JSONObject toJSONObject(JSONArray names) {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jo2 = new JSONObject();
        for (int i2 = 0; i2 < names.length(); ++i2) {
            jo2.put(names.getString(i2), this.opt(i2));
        }
        return jo2;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuffer sb2 = new StringBuffer("[");
        if (len == 1) {
            sb2.append(JSONObject.valueToString(this.myArrayList.get(0), indentFactor, indent));
        } else {
            int i2;
            int newindent = indent + indentFactor;
            sb2.append('\n');
            for (i2 = 0; i2 < len; ++i2) {
                if (i2 > 0) {
                    sb2.append(",\n");
                }
                for (int j2 = 0; j2 < newindent; ++j2) {
                    sb2.append(' ');
                }
                sb2.append(JSONObject.valueToString(this.myArrayList.get(i2), indentFactor, newindent));
            }
            sb2.append('\n');
            for (i2 = 0; i2 < indent; ++i2) {
                sb2.append(' ');
            }
        }
        sb2.append(']');
        return sb2.toString();
    }

    public Writer write(Writer writer) {
        try {
            boolean b2 = false;
            int len = this.length();
            writer.write(91);
            for (int i2 = 0; i2 < len; ++i2) {
                Object v2;
                if (b2) {
                    writer.write(44);
                }
                if ((v2 = this.myArrayList.get(i2)) instanceof JSONObject) {
                    ((JSONObject)v2).write(writer);
                } else if (v2 instanceof JSONArray) {
                    ((JSONArray)v2).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v2));
                }
                b2 = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e2) {
            throw new JSONException(e2);
        }
    }
}

