/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.util.json.JSONArray;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject$Null;
import com.amazonaws.util.json.JSONTokener;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class JSONObject {
    private Map map = new HashMap();
    public static final Object NULL = new JSONObject$Null();

    public JSONObject() {
    }

    public JSONObject(JSONObject jo2, String[] names) {
        this();
        for (int i2 = 0; i2 < names.length; ++i2) {
            try {
                this.putOnce(names[i2], jo2.opt(names[i2]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(JSONTokener x2) {
        this();
        if (x2.nextClean() != '{') {
            throw x2.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c2 = x2.nextClean();
            switch (c2) {
                case '\u0000': {
                    throw x2.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x2.back();
            String key = x2.nextValue().toString();
            c2 = x2.nextClean();
            if (c2 == '=') {
                if (x2.next() != '>') {
                    x2.back();
                }
            } else if (c2 != ':') {
                throw x2.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x2.nextValue());
            switch (x2.nextClean()) {
                case ',': 
                case ';': {
                    if (x2.nextClean() == '}') {
                        return;
                    }
                    x2.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x2.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map map) {
        if (map != null) {
            for (Map.Entry e2 : map.entrySet()) {
                this.map.put(e2.getKey(), JSONObject.wrap(e2.getValue()));
            }
        }
    }

    public JSONObject(Object bean) {
        this();
        this.populateMap(bean);
    }

    public JSONObject(Object object, String[] names) {
        this();
        Class<?> c2 = object.getClass();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            try {
                this.putOpt(name, c2.getField(name).get(object));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(String source) {
        this(new JSONTokener(source));
    }

    public JSONObject accumulate(String key, Object value) {
        JSONObject.testValidity(value);
        Object o2 = this.opt(key);
        if (o2 == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (o2 instanceof JSONArray) {
            ((JSONArray)o2).put(value);
        } else {
            this.put(key, new JSONArray().put(o2).put(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) {
        JSONObject.testValidity(value);
        Object o2 = this.opt(key);
        if (o2 == null) {
            this.put(key, new JSONArray().put(value));
        } else if (o2 instanceof JSONArray) {
            this.put(key, ((JSONArray)o2).put(value));
        } else {
            throw new JSONException("JSONObject[" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return "null";
        }
        String s2 = Double.toString(d2);
        if (s2.indexOf(46) > 0 && s2.indexOf(101) < 0 && s2.indexOf(69) < 0) {
            while (s2.endsWith("0")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            if (s2.endsWith(".")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
        }
        return s2;
    }

    public Object get(String key) {
        Object o2 = this.opt(key);
        if (o2 == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] not found.");
        }
        return o2;
    }

    public boolean getBoolean(String key) {
        Object o2 = this.get(key);
        if (o2.equals(Boolean.FALSE) || o2 instanceof String && ((String)o2).equalsIgnoreCase("false")) {
            return false;
        }
        if (o2.equals(Boolean.TRUE) || o2 instanceof String && ((String)o2).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) {
        Object o2 = this.get(key);
        try {
            return o2 instanceof Number ? ((Number)o2).doubleValue() : Double.valueOf((String)o2).doubleValue();
        }
        catch (Exception e2) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) {
        Object o2 = this.get(key);
        try {
            return o2 instanceof Number ? ((Number)o2).intValue() : Integer.parseInt((String)o2);
        }
        catch (Exception e2) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not an int.");
        }
    }

    public JSONArray getJSONArray(String key) {
        Object o2 = this.get(key);
        if (o2 instanceof JSONArray) {
            return (JSONArray)o2;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) {
        Object o2 = this.get(key);
        if (o2 instanceof JSONObject) {
            return (JSONObject)o2;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) {
        Object o2 = this.get(key);
        try {
            return o2 instanceof Number ? ((Number)o2).longValue() : Long.parseLong((String)o2);
        }
        catch (Exception e2) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a long.");
        }
    }

    public static String[] getNames(JSONObject jo2) {
        int length = jo2.length();
        if (length == 0) {
            return null;
        }
        Iterator i2 = jo2.keys();
        String[] names = new String[length];
        int j2 = 0;
        while (i2.hasNext()) {
            names[j2] = (String)i2.next();
            ++j2;
        }
        return names;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> klass = object.getClass();
        Field[] fields = klass.getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        for (int i2 = 0; i2 < length; ++i2) {
            names[i2] = fields[i2].getName();
        }
        return names;
    }

    public String getString(String key) {
        return this.get(key).toString();
    }

    public String tryGetString(String key) {
        Object o2 = this.opt(key);
        return o2 == null ? null : o2.toString();
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public JSONObject increment(String key) {
        Object value = this.opt(key);
        if (value == null) {
            this.put(key, 1);
        } else if (value instanceof Integer) {
            this.put(key, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.put(key, (Long)value + 1L);
        } else if (value instanceof Double) {
            this.put(key, (Double)value + 1.0);
        } else if (value instanceof Float) {
            this.put(key, ((Float)value).floatValue() + 1.0f);
        } else {
            throw new JSONException("Unable to increment [" + key + "].");
        }
        return this;
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator keys() {
        return this.map.keySet().iterator();
    }

    public int length() {
        return this.map.size();
    }

    public JSONArray names() {
        JSONArray ja2 = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja2.put(keys.next());
        }
        return ja2.length() == 0 ? null : ja2;
    }

    public static String numberToString(Number n2) {
        if (n2 == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(n2);
        String s2 = n2.toString();
        if (s2.indexOf(46) > 0 && s2.indexOf(101) < 0 && s2.indexOf(69) < 0) {
            while (s2.endsWith("0")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            if (s2.endsWith(".")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
        }
        return s2;
    }

    public Object opt(String key) {
        return key == null ? null : this.map.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        try {
            Object o2 = this.opt(key);
            if (o2 instanceof Number) {
                return ((Number)o2).doubleValue();
            }
            return Double.parseDouble((String)o2);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        Object o2 = this.opt(key);
        return o2 instanceof JSONArray ? (JSONArray)o2 : null;
    }

    public JSONObject optJSONObject(String key) {
        Object o2 = this.opt(key);
        return o2 instanceof JSONObject ? (JSONObject)o2 : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o2 = this.opt(key);
        return o2 instanceof String ? o2.toString() : defaultValue;
    }

    private void populateMap(Object bean) {
        Class<?> klass = bean.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        Method[] methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            try {
                Method method = methods[i2];
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = name.equals("getClass") || name.equals("getDeclaringClass") ? "" : name.substring(3);
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                Object result = method.invoke(bean, (Object[])null);
                this.map.put(key, JSONObject.wrap(result));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public JSONObject put(String key, boolean value) {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String key, Collection value) {
        this.put(key, new JSONArray(value));
        return this;
    }

    public JSONObject put(String key, double value) {
        this.put(key, (Object)value);
        return this;
    }

    public JSONObject put(String key, int value) {
        this.put(key, (Object)value);
        return this;
    }

    public JSONObject put(String key, long value) {
        this.put(key, (Object)value);
        return this;
    }

    public JSONObject put(String key, Map value) {
        this.put(key, new JSONObject(value));
        return this;
    }

    public JSONObject put(String key, Object value) {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            JSONObject.testValidity(value);
            this.map.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOnce(String key, Object value) {
        if (key != null && value != null) {
            if (this.opt(key) != null) {
                throw new JSONException("Duplicate key \"" + key + "\"");
            }
            this.put(key, value);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c2 = '\u0000';
        int len = string.length();
        StringBuffer sb2 = new StringBuffer(len + 4);
        sb2.append('\"');
        block9: for (int i2 = 0; i2 < len; ++i2) {
            char b2 = c2;
            c2 = string.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\\': {
                    sb2.append('\\');
                    sb2.append(c2);
                    continue block9;
                }
                case '/': {
                    if (b2 == '<') {
                        sb2.append('\\');
                    }
                    sb2.append(c2);
                    continue block9;
                }
                case '\b': {
                    sb2.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb2.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb2.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb2.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb2.append("\\r");
                    continue block9;
                }
                default: {
                    if (c2 < ' ' || c2 >= '\u0080' && c2 < '\u00a0') {
                        String t2 = "000" + Integer.toHexString(c2);
                        sb2.append("\\u" + t2.substring(t2.length() - 4));
                        continue block9;
                    }
                    sb2.append(c2);
                }
            }
        }
        sb2.append('\"');
        return sb2.toString();
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public Iterator sortedKeys() {
        return new TreeSet(this.map.keySet()).iterator();
    }

    public static Object stringToValue(String s2) {
        if (s2.equals("")) {
            return s2;
        }
        if (s2.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s2.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (s2.equalsIgnoreCase("null")) {
            return NULL;
        }
        char b2 = s2.charAt(0);
        if (b2 >= '0' && b2 <= '9' || b2 == '.' || b2 == '-' || b2 == '+') {
            if (b2 == '0' && s2.length() > 2 && (s2.charAt(1) == 'x' || s2.charAt(1) == 'X')) {
                try {
                    return Integer.valueOf(s2.substring(2), 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (s2.indexOf(46) > -1 || s2.indexOf(101) > -1 || s2.indexOf(69) > -1) {
                    return Double.valueOf(s2);
                }
                Long myLong = Long.valueOf(s2);
                if (myLong == (long)myLong.intValue()) {
                    return myLong.intValue();
                }
                return myLong;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s2;
    }

    static void testValidity(Object o2) {
        if (o2 != null && (o2 instanceof Double ? ((Double)o2).isInfinite() || ((Double)o2).isNaN() : o2 instanceof Float && (((Float)o2).isInfinite() || ((Float)o2).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray names) {
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja2 = new JSONArray();
        for (int i2 = 0; i2 < names.length(); ++i2) {
            ja2.put(this.opt(names.getString(i2)));
        }
        return ja2;
    }

    public String toString() {
        try {
            Iterator keys = this.keys();
            StringBuffer sb2 = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb2.length() > 1) {
                    sb2.append(',');
                }
                Object o2 = keys.next();
                sb2.append(JSONObject.quote(o2.toString()));
                sb2.append(':');
                sb2.append(JSONObject.valueToString(this.map.get(o2)));
            }
            sb2.append('}');
            return sb2.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) {
        int n2 = this.length();
        if (n2 == 0) {
            return "{}";
        }
        Iterator keys = this.sortedKeys();
        StringBuffer sb2 = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n2 == 1) {
            Object o2 = keys.next();
            sb2.append(JSONObject.quote(o2.toString()));
            sb2.append(": ");
            sb2.append(JSONObject.valueToString(this.map.get(o2), indentFactor, indent));
        } else {
            int j2;
            while (keys.hasNext()) {
                Object o3 = keys.next();
                if (sb2.length() > 1) {
                    sb2.append(",\n");
                } else {
                    sb2.append('\n');
                }
                for (j2 = 0; j2 < newindent; ++j2) {
                    sb2.append(' ');
                }
                sb2.append(JSONObject.quote(o3.toString()));
                sb2.append(": ");
                sb2.append(JSONObject.valueToString(this.map.get(o3), indentFactor, newindent));
            }
            if (sb2.length() > 1) {
                sb2.append('\n');
                for (j2 = 0; j2 < indent; ++j2) {
                    sb2.append(' ');
                }
            }
        }
        sb2.append('}');
        return sb2.toString();
    }

    static String valueToString(Object value) {
        if (value == null || value.equals(NULL)) {
            return "null";
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONObject.quote(value.toString());
    }

    static String valueToString(Object value, int indentFactor, int indent) {
        if (value == null || value.equals(NULL)) {
            return "null";
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString(indentFactor, indent);
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString(indentFactor, indent);
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString(indentFactor, indent);
        }
        return JSONObject.quote(value.toString());
    }

    static Object wrap(Object object) {
        try {
            String objectPackageName;
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof String || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            Package objectPackage = object.getClass().getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Writer write(Writer writer) {
        try {
            boolean b2 = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b2) {
                    writer.write(44);
                }
                Object k2 = keys.next();
                writer.write(JSONObject.quote(k2.toString()));
                writer.write(58);
                Object v2 = this.map.get(k2);
                if (v2 instanceof JSONObject) {
                    ((JSONObject)v2).write(writer);
                } else if (v2 instanceof JSONArray) {
                    ((JSONArray)v2).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v2));
                }
                b2 = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }
}

