/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Date;

public class JSONWriter {
    private static final int maxdepth = 70;
    private boolean comma = false;
    protected char mode = (char)105;
    private JSONObject[] stack = new JSONObject[70];
    private int top = 0;
    protected Writer writer;

    public JSONWriter(Writer w2) {
        this.writer = w2;
    }

    private JSONWriter append(String s2) {
        if (s2 == null) {
            throw new JSONException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.writer.write(44);
                }
                this.writer.write(s2);
            }
            catch (IOException e2) {
                throw new JSONException(e2);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence.");
    }

    public JSONWriter array() {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push(null);
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced array.");
    }

    private JSONWriter end(char m2, char c2) {
        if (this.mode != m2) {
            throw new JSONException(m2 == 'a' ? "Misplaced endArray." : "Misplaced endObject.");
        }
        this.pop(m2);
        try {
            this.writer.write(c2);
        }
        catch (IOException e2) {
            throw new JSONException(e2);
        }
        this.comma = true;
        return this;
    }

    public JSONWriter endArray() {
        return this.end('a', ']');
    }

    public JSONWriter endObject() {
        return this.end('k', '}');
    }

    public JSONWriter key(String s2) {
        if (s2 == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == 'k') {
            try {
                this.stack[this.top - 1].putOnce(s2, Boolean.TRUE);
                if (this.comma) {
                    this.writer.write(44);
                }
                this.writer.write(JSONObject.quote(s2));
                this.writer.write(58);
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException e2) {
                throw new JSONException(e2);
            }
        }
        throw new JSONException("Misplaced key.");
    }

    public JSONWriter object() {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push(new JSONObject());
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced object.");
    }

    private void pop(char c2) {
        char m2;
        if (this.top <= 0) {
            throw new JSONException("Nesting error.");
        }
        char c3 = m2 = this.stack[this.top - 1] == null ? (char)'a' : 'k';
        if (m2 != c2) {
            throw new JSONException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : (this.stack[this.top - 1] == null ? 97 : 107));
    }

    private void push(JSONObject jo2) {
        if (this.top >= 70) {
            throw new JSONException("Nesting too deep.");
        }
        this.stack[this.top] = jo2;
        this.mode = (char)(jo2 == null ? 97 : 107);
        ++this.top;
    }

    public JSONWriter value(boolean b2) {
        return this.append(b2 ? "true" : "false");
    }

    public JSONWriter value(double d2) {
        return this.value(new Double(d2));
    }

    public JSONWriter value(long l2) {
        return this.value((Object)l2);
    }

    public JSONWriter value(Date date) {
        return this.append(DateUtils.formatServiceSpecificDate(date));
    }

    public JSONWriter value(ByteBuffer b2) {
        b2.mark();
        byte[] bytes = new byte[b2.remaining()];
        b2.get(bytes, 0, bytes.length);
        b2.reset();
        return this.value(BinaryUtils.toBase64(bytes));
    }

    public JSONWriter value(Object o2) {
        return this.append(JSONObject.valueToString(o2));
    }
}

