/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.AmazonClientException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public enum Jackson {

    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final fV writer;
    private static final fV prettyWriter;

    public static String toJsonPrettyString(Object value) {
        try {
            return prettyWriter.writeValueAsString(value);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static String toJsonString(Object value) {
        try {
            return writer.writeValueAsString(value);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return objectMapper.readValue(json, clazz);
        }
        catch (Exception e2) {
            throw new AmazonClientException("Unable to parse Json String.", e2);
        }
    }

    public static fH jsonNodeOf(String json) {
        return Jackson.fromJsonString(json, fH.class);
    }

    public static JsonGenerator jsonGeneratorOf(Writer writer) {
        return new JsonFactory().createGenerator(writer);
    }

    public static <T> T loadFrom(File file, Class<T> clazz) {
        try {
            return objectMapper.readValue(file, clazz);
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new IllegalStateException(e3);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static fV getWriter() {
        return writer;
    }

    public static fV getPrettywriter() {
        return prettyWriter;
    }

    static {
        objectMapper.configure(JsonParser$Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        writer = objectMapper.writer();
        prettyWriter = objectMapper.writerWithDefaultPrettyPrinter();
    }
}

