/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory$Feature;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.util.BufferRecycler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;

public class JsonFactory
implements Serializable {
    private static final long serialVersionUID = 3194418244231611666L;
    public static final String FORMAT_NAME_JSON = "JSON";
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = JsonFactory$Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser$Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator$Feature.collectDefaults();
    private static final en DEFAULT_ROOT_VALUE_SEPARATOR = fi.DEFAULT_ROOT_VALUE_SEPARATOR;
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    protected final transient eX _rootCharSymbols = eX.a();
    protected final transient eU _rootByteSymbols = eU.a();
    protected el _objectCodec;
    protected int _factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
    protected int _parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
    protected int _generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
    protected ey _characterEscapes;
    protected eA _inputDecorator;
    protected eF _outputDecorator;
    protected en _rootValueSeparator = DEFAULT_ROOT_VALUE_SEPARATOR;

    public JsonFactory() {
        this(null);
    }

    public JsonFactory(el el2) {
        this._objectCodec = el2;
    }

    protected JsonFactory(JsonFactory jsonFactory, el el2) {
        this._objectCodec = null;
        this._factoryFeatures = jsonFactory._factoryFeatures;
        this._parserFeatures = jsonFactory._parserFeatures;
        this._generatorFeatures = jsonFactory._generatorFeatures;
        this._characterEscapes = jsonFactory._characterEscapes;
        this._inputDecorator = jsonFactory._inputDecorator;
        this._outputDecorator = jsonFactory._outputDecorator;
        this._rootValueSeparator = jsonFactory._rootValueSeparator;
    }

    public JsonFactory copy() {
        this._checkInvalidCopy(JsonFactory.class);
        return new JsonFactory(this, null);
    }

    protected void _checkInvalidCopy(Class<?> clazz) {
        if (this.getClass() != clazz) {
            throw new IllegalStateException("Failed copy(): " + this.getClass().getName() + " (version: " + this.version() + ") does not override copy(); it has to");
        }
    }

    protected Object readResolve() {
        return new JsonFactory(this, this._objectCodec);
    }

    public boolean requiresPropertyOrdering() {
        return false;
    }

    public boolean canHandleBinaryNatively() {
        return false;
    }

    public boolean canUseSchema(ef ef2) {
        String string = this.getFormatName();
        return string != null && string.equals(ef2.a());
    }

    public String getFormatName() {
        if (this.getClass() == JsonFactory.class) {
            return FORMAT_NAME_JSON;
        }
        return null;
    }

    public MatchStrength hasFormat(eu eu2) {
        if (this.getClass() == JsonFactory.class) {
            return this.hasJSONFormat(eu2);
        }
        return null;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    protected MatchStrength hasJSONFormat(eu eu2) {
        return eK.a(eu2);
    }

    public eq version() {
        return eP.a;
    }

    public final JsonFactory configure(JsonFactory$Feature jsonFactory$Feature, boolean bl2) {
        return bl2 ? this.enable(jsonFactory$Feature) : this.disable(jsonFactory$Feature);
    }

    public JsonFactory enable(JsonFactory$Feature jsonFactory$Feature) {
        this._factoryFeatures |= jsonFactory$Feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonFactory$Feature jsonFactory$Feature) {
        this._factoryFeatures &= ~jsonFactory$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonFactory$Feature jsonFactory$Feature) {
        return (this._factoryFeatures & jsonFactory$Feature.getMask()) != 0;
    }

    public final JsonFactory configure(JsonParser$Feature jsonParser$Feature, boolean bl2) {
        return bl2 ? this.enable(jsonParser$Feature) : this.disable(jsonParser$Feature);
    }

    public JsonFactory enable(JsonParser$Feature jsonParser$Feature) {
        this._parserFeatures |= jsonParser$Feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonParser$Feature jsonParser$Feature) {
        this._parserFeatures &= ~jsonParser$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return (this._parserFeatures & jsonParser$Feature.getMask()) != 0;
    }

    public eA getInputDecorator() {
        return this._inputDecorator;
    }

    public JsonFactory setInputDecorator(eA eA2) {
        this._inputDecorator = eA2;
        return this;
    }

    public final JsonFactory configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl2) {
        return bl2 ? this.enable(jsonGenerator$Feature) : this.disable(jsonGenerator$Feature);
    }

    public JsonFactory enable(JsonGenerator$Feature jsonGenerator$Feature) {
        this._generatorFeatures |= jsonGenerator$Feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonGenerator$Feature jsonGenerator$Feature) {
        this._generatorFeatures &= ~jsonGenerator$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonGenerator$Feature jsonGenerator$Feature) {
        return (this._generatorFeatures & jsonGenerator$Feature.getMask()) != 0;
    }

    public ey getCharacterEscapes() {
        return this._characterEscapes;
    }

    public JsonFactory setCharacterEscapes(ey ey2) {
        this._characterEscapes = ey2;
        return this;
    }

    public eF getOutputDecorator() {
        return this._outputDecorator;
    }

    public JsonFactory setOutputDecorator(eF eF2) {
        this._outputDecorator = eF2;
        return this;
    }

    public JsonFactory setRootValueSeparator(String string) {
        this._rootValueSeparator = string == null ? null : new eH(string);
        return this;
    }

    public String getRootValueSeparator() {
        return this._rootValueSeparator == null ? null : this._rootValueSeparator.getValue();
    }

    public JsonFactory setCodec(el el2) {
        this._objectCodec = el2;
        return this;
    }

    public el getCodec() {
        return this._objectCodec;
    }

    public JsonParser createParser(File file) {
        ez ez2 = this._createContext(file, true);
        InputStream inputStream = new FileInputStream(file);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(ez2, inputStream);
        }
        return this._createParser(inputStream, ez2);
    }

    public JsonParser createParser(URL uRL) {
        ez ez2 = this._createContext(uRL, true);
        InputStream inputStream = this._optimizedStreamFromURL(uRL);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(ez2, inputStream);
        }
        return this._createParser(inputStream, ez2);
    }

    public JsonParser createParser(InputStream inputStream) {
        ez ez2 = this._createContext(inputStream, false);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(ez2, inputStream);
        }
        return this._createParser(inputStream, ez2);
    }

    public JsonParser createParser(Reader reader) {
        ez ez2 = this._createContext(reader, false);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(ez2, reader);
        }
        return this._createParser(reader, ez2);
    }

    public JsonParser createParser(byte[] byArray) {
        InputStream inputStream;
        ez ez2 = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(ez2, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream, ez2);
        }
        return this._createParser(byArray, 0, byArray.length, ez2);
    }

    public JsonParser createParser(byte[] byArray, int n2, int n3) {
        InputStream inputStream;
        ez ez2 = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(ez2, byArray, n2, n3)) != null) {
            return this._createParser(inputStream, ez2);
        }
        return this._createParser(byArray, n2, n3, ez2);
    }

    public JsonParser createParser(String string) {
        Reader reader = new StringReader(string);
        ez ez2 = this._createContext(reader, true);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(ez2, reader);
        }
        return this._createParser(reader, ez2);
    }

    @Deprecated
    public JsonParser createJsonParser(File file) {
        return this.createParser(file);
    }

    @Deprecated
    public JsonParser createJsonParser(URL uRL) {
        return this.createParser(uRL);
    }

    @Deprecated
    public JsonParser createJsonParser(InputStream inputStream) {
        return this.createParser(inputStream);
    }

    @Deprecated
    public JsonParser createJsonParser(Reader reader) {
        return this.createParser(reader);
    }

    @Deprecated
    public JsonParser createJsonParser(byte[] byArray) {
        return this.createParser(byArray);
    }

    @Deprecated
    public JsonParser createJsonParser(byte[] byArray, int n2, int n3) {
        return this.createParser(byArray, n2, n3);
    }

    @Deprecated
    public JsonParser createJsonParser(String string) {
        return this.createParser(string);
    }

    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        ez ez2 = this._createContext(outputStream, false);
        ez2.a(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            if (this._outputDecorator != null) {
                outputStream = this._outputDecorator.decorate(ez2, outputStream);
            }
            return this._createUTF8Generator(outputStream, ez2);
        }
        Writer writer = this._createWriter(outputStream, jsonEncoding, ez2);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(ez2, writer);
        }
        return this._createGenerator(writer, ez2);
    }

    public JsonGenerator createGenerator(OutputStream outputStream) {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    public JsonGenerator createGenerator(Writer writer) {
        ez ez2 = this._createContext(writer, false);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(ez2, writer);
        }
        return this._createGenerator(writer, ez2);
    }

    public JsonGenerator createGenerator(File file, JsonEncoding jsonEncoding) {
        OutputStream outputStream = new FileOutputStream(file);
        ez ez2 = this._createContext(outputStream, true);
        ez2.a(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            if (this._outputDecorator != null) {
                outputStream = this._outputDecorator.decorate(ez2, outputStream);
            }
            return this._createUTF8Generator(outputStream, ez2);
        }
        Writer writer = this._createWriter(outputStream, jsonEncoding, ez2);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(ez2, writer);
        }
        return this._createGenerator(writer, ez2);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        return this.createGenerator(outputStream, jsonEncoding);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(Writer writer) {
        return this.createGenerator(writer);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream outputStream) {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(File file, JsonEncoding jsonEncoding) {
        return this.createGenerator(file, jsonEncoding);
    }

    protected JsonParser _createParser(InputStream inputStream, ez ez2) {
        return new eK(ez2, inputStream).a(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols, this.isEnabled(JsonFactory$Feature.CANONICALIZE_FIELD_NAMES), this.isEnabled(JsonFactory$Feature.INTERN_FIELD_NAMES));
    }

    @Deprecated
    protected JsonParser _createJsonParser(InputStream inputStream, ez ez2) {
        return this._createParser(inputStream, ez2);
    }

    protected JsonParser _createParser(Reader reader, ez ez2) {
        return new eQ(ez2, this._parserFeatures, reader, this._objectCodec, this._rootCharSymbols.a(this.isEnabled(JsonFactory$Feature.CANONICALIZE_FIELD_NAMES), this.isEnabled(JsonFactory$Feature.INTERN_FIELD_NAMES)));
    }

    @Deprecated
    protected JsonParser _createJsonParser(Reader reader, ez ez2) {
        return this._createParser(reader, ez2);
    }

    protected JsonParser _createParser(byte[] byArray, int n2, int n3, ez ez2) {
        return new eK(ez2, byArray, n2, n3).a(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols, this.isEnabled(JsonFactory$Feature.CANONICALIZE_FIELD_NAMES), this.isEnabled(JsonFactory$Feature.INTERN_FIELD_NAMES));
    }

    @Deprecated
    protected JsonParser _createJsonParser(byte[] byArray, int n2, int n3, ez ez2) {
        return this._createParser(byArray, n2, n3, ez2);
    }

    protected JsonGenerator _createGenerator(Writer writer, ez ez2) {
        en en2;
        eT eT2 = new eT(ez2, this._generatorFeatures, this._objectCodec, writer);
        if (this._characterEscapes != null) {
            eT2.a(this._characterEscapes);
        }
        if ((en2 = this._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            eT2.a(en2);
        }
        return eT2;
    }

    @Deprecated
    protected JsonGenerator _createJsonGenerator(Writer writer, ez ez2) {
        return this._createGenerator(writer, ez2);
    }

    protected JsonGenerator _createUTF8Generator(OutputStream outputStream, ez ez2) {
        en en2;
        eR eR2 = new eR(ez2, this._generatorFeatures, this._objectCodec, outputStream);
        if (this._characterEscapes != null) {
            eR2.a(this._characterEscapes);
        }
        if ((en2 = this._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            eR2.a(en2);
        }
        return eR2;
    }

    @Deprecated
    protected JsonGenerator _createUTF8JsonGenerator(OutputStream outputStream, ez ez2) {
        return this._createUTF8Generator(outputStream, ez2);
    }

    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, ez ez2) {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new eJ(ez2, outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected ez _createContext(Object object, boolean bl2) {
        return new ez(this._getBufferRecycler(), object, bl2);
    }

    public BufferRecycler _getBufferRecycler() {
        BufferRecycler bufferRecycler;
        SoftReference<BufferRecycler> softReference = _recyclerRef.get();
        BufferRecycler bufferRecycler2 = bufferRecycler = softReference == null ? null : softReference.get();
        if (bufferRecycler == null) {
            bufferRecycler = new BufferRecycler();
            _recyclerRef.set(new SoftReference<BufferRecycler>(bufferRecycler));
        }
        return bufferRecycler;
    }

    protected InputStream _optimizedStreamFromURL(URL uRL) {
        String string;
        String string2;
        if ("file".equals(uRL.getProtocol()) && ((string2 = uRL.getHost()) == null || string2.length() == 0) && (string = uRL.getPath()).indexOf(37) < 0) {
            return new FileInputStream(uRL.getPath());
        }
        return uRL.openStream();
    }
}

