/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.LinkedTreeMap$1;
import com.google.gson.internal.LinkedTreeMap$EntrySet;
import com.google.gson.internal.LinkedTreeMap$KeySet;
import com.google.gson.internal.LinkedTreeMap$Node;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class LinkedTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Comparator<Comparable> NATURAL_ORDER = new LinkedTreeMap$1();
    Comparator<? super K> comparator;
    LinkedTreeMap$Node<K, V> root;
    int size = 0;
    int modCount = 0;
    final LinkedTreeMap$Node<K, V> header = new LinkedTreeMap$Node();
    private LinkedTreeMap$EntrySet entrySet;
    private LinkedTreeMap$KeySet keySet;

    public LinkedTreeMap() {
        this(NATURAL_ORDER);
    }

    public LinkedTreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator != null ? comparator : NATURAL_ORDER;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(Object key) {
        LinkedTreeMap$Node<K, V> node = this.findByObject(key);
        return (V)(node != null ? node.b : null);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findByObject(key) != null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LinkedTreeMap$Node<K, V> created = this.find(key, true);
        LinkedTreeMap$Node result = created.b;
        created.b = value;
        return (V)result;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
        LinkedTreeMap$Node<K, V> header = this.header;
        header.e = header;
        header.d = header.e;
    }

    @Override
    public V remove(Object key) {
        LinkedTreeMap$Node<K, V> node = this.removeInternalByKey(key);
        return (V)(node != null ? node.b : null);
    }

    LinkedTreeMap$Node<K, V> find(K key, boolean create) {
        LinkedTreeMap$Node<K, V> created;
        Comparator<K> comparator = this.comparator;
        LinkedTreeMap$Node<K, V> nearest = this.root;
        int comparison = 0;
        if (nearest != null) {
            Comparable comparableKey = comparator == NATURAL_ORDER ? (Comparable)key : null;
            while (true) {
                LinkedTreeMap$Node child;
                int n2 = comparison = comparableKey != null ? comparableKey.compareTo(nearest.a) : comparator.compare(key, nearest.a);
                if (comparison == 0) {
                    return nearest;
                }
                LinkedTreeMap$Node linkedTreeMap$Node = child = comparison < 0 ? nearest.b : nearest.c;
                if (child == null) break;
                nearest = child;
            }
        }
        if (!create) {
            return null;
        }
        LinkedTreeMap$Node<K, V> header = this.header;
        if (nearest == null) {
            if (comparator == NATURAL_ORDER && !(key instanceof Comparable)) {
                throw new ClassCastException(key.getClass().getName() + " is not Comparable");
            }
            created = new LinkedTreeMap$Node<K, V>(nearest, key, header, header.e);
            this.root = created;
        } else {
            created = new LinkedTreeMap$Node<K, V>(nearest, key, header, header.e);
            if (comparison < 0) {
                nearest.b = created;
            } else {
                nearest.c = created;
            }
            this.rebalance(nearest, true);
        }
        ++this.size;
        ++this.modCount;
        return created;
    }

    LinkedTreeMap$Node<K, V> findByObject(Object key) {
        try {
            return key != null ? this.find(key, false) : null;
        }
        catch (ClassCastException e2) {
            return null;
        }
    }

    LinkedTreeMap$Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        LinkedTreeMap$Node<K, V> mine = this.findByObject(entry.getKey());
        boolean valuesEqual = mine != null && this.equal(mine.b, entry.getValue());
        return valuesEqual ? mine : null;
    }

    private boolean equal(Object a2, Object b2) {
        return a2 == b2 || a2 != null && a2.equals(b2);
    }

    void removeInternal(LinkedTreeMap$Node<K, V> node, boolean unlink) {
        if (unlink) {
            node.e.d = node.d;
            node.d.e = node.e;
        }
        LinkedTreeMap$Node left = node.b;
        LinkedTreeMap$Node right = node.c;
        LinkedTreeMap$Node originalParent = node.a;
        if (left != null && right != null) {
            LinkedTreeMap$Node adjacent = left.a > right.a ? left.b() : right.a();
            this.removeInternal(adjacent, false);
            int leftHeight = 0;
            left = node.b;
            if (left != null) {
                leftHeight = left.a;
                adjacent.b = left;
                left.a = adjacent;
                node.b = null;
            }
            int rightHeight = 0;
            right = node.c;
            if (right != null) {
                rightHeight = right.a;
                adjacent.c = right;
                right.a = adjacent;
                node.c = null;
            }
            adjacent.a = Math.max(leftHeight, rightHeight) + 1;
            this.replaceInParent(node, adjacent);
            return;
        }
        if (left != null) {
            this.replaceInParent(node, left);
            node.b = null;
        } else if (right != null) {
            this.replaceInParent(node, right);
            node.c = null;
        } else {
            this.replaceInParent(node, null);
        }
        this.rebalance(originalParent, false);
        --this.size;
        ++this.modCount;
    }

    LinkedTreeMap$Node<K, V> removeInternalByKey(Object key) {
        LinkedTreeMap$Node<K, V> node = this.findByObject(key);
        if (node != null) {
            this.removeInternal(node, true);
        }
        return node;
    }

    private void replaceInParent(LinkedTreeMap$Node<K, V> node, LinkedTreeMap$Node<K, V> replacement) {
        LinkedTreeMap$Node parent = node.a;
        node.a = null;
        if (replacement != null) {
            replacement.a = parent;
        }
        if (parent != null) {
            if (parent.b == node) {
                parent.b = replacement;
            } else {
                assert (parent.c == node);
                parent.c = replacement;
            }
        } else {
            this.root = replacement;
        }
    }

    private void rebalance(LinkedTreeMap$Node<K, V> unbalanced, boolean insert) {
        LinkedTreeMap$Node<K, V> node = unbalanced;
        while (node != null) {
            LinkedTreeMap$Node right;
            int rightHeight;
            LinkedTreeMap$Node left = node.b;
            int leftHeight = left != null ? left.a : 0;
            int delta = leftHeight - (rightHeight = (right = node.c) != null ? right.a : 0);
            if (delta == -2) {
                LinkedTreeMap$Node rightRight;
                int rightRightHeight;
                LinkedTreeMap$Node rightLeft = right.b;
                int rightLeftHeight = rightLeft != null ? rightLeft.a : 0;
                int rightDelta = rightLeftHeight - (rightRightHeight = (rightRight = right.c) != null ? rightRight.a : 0);
                if (rightDelta == -1 || rightDelta == 0 && !insert) {
                    this.rotateLeft(node);
                } else {
                    assert (rightDelta == 1);
                    this.rotateRight(right);
                    this.rotateLeft(node);
                }
                if (insert) {
                    break;
                }
            } else if (delta == 2) {
                LinkedTreeMap$Node leftRight;
                int leftRightHeight;
                LinkedTreeMap$Node leftLeft = left.b;
                int leftLeftHeight = leftLeft != null ? leftLeft.a : 0;
                int leftDelta = leftLeftHeight - (leftRightHeight = (leftRight = left.c) != null ? leftRight.a : 0);
                if (leftDelta == 1 || leftDelta == 0 && !insert) {
                    this.rotateRight(node);
                } else {
                    assert (leftDelta == -1);
                    this.rotateLeft(left);
                    this.rotateRight(node);
                }
                if (insert) {
                    break;
                }
            } else if (delta == 0) {
                node.a = leftHeight + 1;
                if (insert) {
                    break;
                }
            } else {
                assert (delta == -1 || delta == 1);
                node.a = Math.max(leftHeight, rightHeight) + 1;
                if (!insert) break;
            }
            node = node.a;
        }
    }

    private void rotateLeft(LinkedTreeMap$Node<K, V> root) {
        LinkedTreeMap$Node left = root.b;
        LinkedTreeMap$Node pivot = root.c;
        LinkedTreeMap$Node pivotLeft = pivot.b;
        LinkedTreeMap$Node pivotRight = pivot.c;
        root.c = pivotLeft;
        if (pivotLeft != null) {
            pivotLeft.a = root;
        }
        this.replaceInParent(root, pivot);
        pivot.b = root;
        root.a = pivot;
        root.a = Math.max(left != null ? left.a : 0, pivotLeft != null ? pivotLeft.a : 0) + 1;
        pivot.a = Math.max(root.a, pivotRight != null ? pivotRight.a : 0) + 1;
    }

    private void rotateRight(LinkedTreeMap$Node<K, V> root) {
        LinkedTreeMap$Node pivot = root.b;
        LinkedTreeMap$Node right = root.c;
        LinkedTreeMap$Node pivotLeft = pivot.b;
        LinkedTreeMap$Node pivotRight = pivot.c;
        root.b = pivotRight;
        if (pivotRight != null) {
            pivotRight.a = root;
        }
        this.replaceInParent(root, pivot);
        pivot.c = root;
        root.a = pivot;
        root.a = Math.max(right != null ? right.a : 0, pivotRight != null ? pivotRight.a : 0) + 1;
        pivot.a = Math.max(root.a, pivotLeft != null ? pivotLeft.a : 0) + 1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedTreeMap$EntrySet result = this.entrySet;
        return result != null ? result : (this.entrySet = new LinkedTreeMap$EntrySet(this));
    }

    @Override
    public Set<K> keySet() {
        LinkedTreeMap$KeySet result = this.keySet;
        return result != null ? result : (this.keySet = new LinkedTreeMap$KeySet(this));
    }

    private Object writeReplace() {
        return new LinkedHashMap(this);
    }
}

