/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.oned.Code128Writer$CType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class Code128Writer
extends pH {
    @Override
    public pd a(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) {
        if (format != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got ".concat(String.valueOf((Object)format)));
        }
        return super.a(contents, format, width, height, hints);
    }

    @Override
    public boolean[] a(String contents) {
        int length = contents.length();
        if (length <= 0 || length > 80) {
            throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got ".concat(String.valueOf(length)));
        }
        block17: for (int i2 = 0; i2 < length; ++i2) {
            char c2 = contents.charAt(i2);
            switch (c2) {
                case '\u00f1': 
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': {
                    continue block17;
                }
                default: {
                    if (c2 <= '\u007f') continue block17;
                    throw new IllegalArgumentException("Bad character in input: ".concat(String.valueOf(c2)));
                }
            }
        }
        ArrayList<int[]> patterns = new ArrayList<int[]>();
        int checkSum = 0;
        int checkWeight = 1;
        int codeSet = 0;
        int position = 0;
        while (position < length) {
            int patternIndex;
            int newCodeSet = Code128Writer.a(contents, position, codeSet);
            if (newCodeSet == codeSet) {
                block3 : switch (contents.charAt(position)) {
                    case '\u00f1': {
                        patternIndex = 102;
                        break;
                    }
                    case '\u00f2': {
                        patternIndex = 97;
                        break;
                    }
                    case '\u00f3': {
                        patternIndex = 96;
                        break;
                    }
                    case '\u00f4': {
                        if (codeSet == 101) {
                            patternIndex = 101;
                            break;
                        }
                        patternIndex = 100;
                        break;
                    }
                    default: {
                        switch (codeSet) {
                            case 101: {
                                patternIndex = contents.charAt(position) - 32;
                                if (patternIndex >= 0) break block3;
                                patternIndex += 96;
                                break block3;
                            }
                            case 100: {
                                patternIndex = contents.charAt(position) - 32;
                                break block3;
                            }
                            default: {
                                int n2 = position++;
                                patternIndex = Integer.parseInt(contents.substring(n2, n2 + 2));
                            }
                        }
                    }
                }
                ++position;
            } else {
                if (codeSet == 0) {
                    switch (newCodeSet) {
                        case 101: {
                            patternIndex = 103;
                            break;
                        }
                        case 100: {
                            patternIndex = 104;
                            break;
                        }
                        default: {
                            patternIndex = 105;
                            break;
                        }
                    }
                } else {
                    patternIndex = newCodeSet;
                }
                codeSet = newCodeSet;
            }
            patterns.add(px.a[patternIndex]);
            checkSum += patternIndex * checkWeight;
            if (position == 0) continue;
            ++checkWeight;
        }
        patterns.add(px.a[checkSum %= 103]);
        patterns.add(px.a[106]);
        int codeWidth = 0;
        Iterator patternIndex = patterns.iterator();
        while (patternIndex.hasNext()) {
            for (int width : (int[])patternIndex.next()) {
                codeWidth += width;
            }
        }
        boolean[] result = new boolean[codeWidth];
        int pos = 0;
        Object object = patterns.iterator();
        while (object.hasNext()) {
            int[] pattern = (int[])object.next();
            pos += Code128Writer.a(result, pos, pattern, true);
        }
        return result;
    }

    private static Code128Writer$CType a(CharSequence value, int start) {
        int last = value.length();
        if (start >= last) {
            return Code128Writer$CType.UNCODABLE;
        }
        char c2 = value.charAt(start);
        if (c2 == '\u00f1') {
            return Code128Writer$CType.FNC_1;
        }
        if (c2 < '0' || c2 > '9') {
            return Code128Writer$CType.UNCODABLE;
        }
        if (start + 1 >= last) {
            return Code128Writer$CType.ONE_DIGIT;
        }
        c2 = value.charAt(start + 1);
        if (c2 < '0' || c2 > '9') {
            return Code128Writer$CType.ONE_DIGIT;
        }
        return Code128Writer$CType.TWO_DIGITS;
    }

    private static int a(CharSequence value, int start, int oldCode) {
        Code128Writer$CType lookahead = Code128Writer.a(value, start);
        if (lookahead == Code128Writer$CType.ONE_DIGIT) {
            if (oldCode == 101) {
                return 101;
            }
            return 100;
        }
        if (lookahead == Code128Writer$CType.UNCODABLE) {
            char c2;
            if (start < value.length() && ((c2 = value.charAt(start)) < ' ' || oldCode == 101 && (c2 < '`' || c2 >= '\u00f1' && c2 <= '\u00f4'))) {
                return 101;
            }
            return 100;
        }
        if (oldCode == 101 && lookahead == Code128Writer$CType.FNC_1) {
            return 101;
        }
        if (oldCode == 99) {
            return 99;
        }
        if (oldCode == 100) {
            if (lookahead == Code128Writer$CType.FNC_1) {
                return 100;
            }
            lookahead = Code128Writer.a(value, start + 2);
            if (lookahead == Code128Writer$CType.UNCODABLE || lookahead == Code128Writer$CType.ONE_DIGIT) {
                return 100;
            }
            if (lookahead == Code128Writer$CType.FNC_1) {
                if (Code128Writer.a(value, start + 3) == Code128Writer$CType.TWO_DIGITS) {
                    return 99;
                }
                return 100;
            }
            int index = start + 4;
            while ((lookahead = Code128Writer.a(value, index)) == Code128Writer$CType.TWO_DIGITS) {
                index += 2;
            }
            if (lookahead == Code128Writer$CType.ONE_DIGIT) {
                return 100;
            }
            return 99;
        }
        if (lookahead == Code128Writer$CType.FNC_1) {
            lookahead = Code128Writer.a(value, start + 1);
        }
        if (lookahead == Code128Writer$CType.TWO_DIGITS) {
            return 99;
        }
        return 100;
    }
}

