/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.ng.business.messagecenter.common.model;

import com.sankuai.ng.business.messagecenter.common.model.MessageCatalogEnum;
import com.sankuai.ng.business.messagecenter.common.model.MessageTypeEnum;
import com.sankuai.ng.business.messagecenter.common.model.UserActionVO;
import com.sankuai.ng.common.annotation.Keep;
import java.beans.ConstructorProperties;
import java.util.Arrays;

@Keep
public class MessageVO {
    private String id;
    private MessageTypeEnum type;
    private MessageCatalogEnum catalog;
    private int priority;
    private int duration;
    private String title;
    private String content;
    private long time;
    private String hint;
    private boolean autoCancelAddToDo;
    private UserActionVO btnBodyAction;
    private UserActionVO btnFirstAction;
    private UserActionVO btnSecondAction;
    private String[] voiceStr;
    private Object data;
    private Integer version;

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MessageVO messageVO = (MessageVO)o2;
        if (this.id != null) {
            return this.id.equals(messageVO.id);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean canUpdateBy(MessageVO newMsg) {
        return this.getVersion() == null || newMsg.getVersion() == null || newMsg.getVersion() >= this.getVersion();
    }

    public static to builder() {
        return new to();
    }

    public String toString() {
        return "MessageVO(id=" + this.getId() + ", type=" + (Object)((Object)this.getType()) + ", catalog=" + (Object)((Object)this.getCatalog()) + ", priority=" + this.getPriority() + ", duration=" + this.getDuration() + ", title=" + this.getTitle() + ", content=" + this.getContent() + ", time=" + this.getTime() + ", hint=" + this.getHint() + ", autoCancelAddToDo=" + this.isAutoCancelAddToDo() + ", btnBodyAction=" + this.getBtnBodyAction() + ", btnFirstAction=" + this.getBtnFirstAction() + ", btnSecondAction=" + this.getBtnSecondAction() + ", voiceStr=" + Arrays.deepToString(this.getVoiceStr()) + ", data=" + this.getData() + ", version=" + this.getVersion() + ")";
    }

    public String getId() {
        return this.id;
    }

    public MessageTypeEnum getType() {
        return this.type;
    }

    public MessageCatalogEnum getCatalog() {
        return this.catalog;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public long getTime() {
        return this.time;
    }

    public String getHint() {
        return this.hint;
    }

    public boolean isAutoCancelAddToDo() {
        return this.autoCancelAddToDo;
    }

    public UserActionVO getBtnBodyAction() {
        return this.btnBodyAction;
    }

    public UserActionVO getBtnFirstAction() {
        return this.btnFirstAction;
    }

    public UserActionVO getBtnSecondAction() {
        return this.btnSecondAction;
    }

    public String[] getVoiceStr() {
        return this.voiceStr;
    }

    public Object getData() {
        return this.data;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public void setType(MessageTypeEnum type) {
        this.type = type;
    }

    public void setCatalog(MessageCatalogEnum catalog) {
        this.catalog = catalog;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public void setAutoCancelAddToDo(boolean autoCancelAddToDo) {
        this.autoCancelAddToDo = autoCancelAddToDo;
    }

    public void setBtnBodyAction(UserActionVO btnBodyAction) {
        this.btnBodyAction = btnBodyAction;
    }

    public void setBtnFirstAction(UserActionVO btnFirstAction) {
        this.btnFirstAction = btnFirstAction;
    }

    public void setBtnSecondAction(UserActionVO btnSecondAction) {
        this.btnSecondAction = btnSecondAction;
    }

    public void setVoiceStr(String[] voiceStr) {
        this.voiceStr = voiceStr;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ConstructorProperties(value={"id", "type", "catalog", "priority", "duration", "title", "content", "time", "hint", "autoCancelAddToDo", "btnBodyAction", "btnFirstAction", "btnSecondAction", "voiceStr", "data", "version"})
    public MessageVO(String id2, MessageTypeEnum type, MessageCatalogEnum catalog, int priority, int duration, String title, String content, long time, String hint, boolean autoCancelAddToDo, UserActionVO btnBodyAction, UserActionVO btnFirstAction, UserActionVO btnSecondAction, String[] voiceStr, Object data, Integer version) {
        this.id = id2;
        this.type = type;
        this.catalog = catalog;
        this.priority = priority;
        this.duration = duration;
        this.title = title;
        this.content = content;
        this.time = time;
        this.hint = hint;
        this.autoCancelAddToDo = autoCancelAddToDo;
        this.btnBodyAction = btnBodyAction;
        this.btnFirstAction = btnFirstAction;
        this.btnSecondAction = btnSecondAction;
        this.voiceStr = voiceStr;
        this.data = data;
        this.version = version;
    }

    public MessageVO() {
    }
}

