/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.ng.common.time.win.timetools;

import com.sankuai.ng.common.time.win.timetools.LogManager;
import com.sankuai.ng.common.time.win.timetools.Tools;

public class ElapseTimeSync {
    private static final String TAG = "ElapseTimeSync";
    private boolean mSynced = false;
    private long mBaseNanoTime = 0L;
    private long mBaseRealTime = 0L;
    private int mCountNotSync = 0;
    private static final int POWERMOD = 31;
    private static final int MASK = Integer.MAX_VALUE;

    public boolean isSync() {
        return this.mSynced;
    }

    public void syncTime(long curRealTime) {
        this.mBaseRealTime = curRealTime;
        this.mBaseNanoTime = Tools.getNanoTime();
        this.mSynced = true;
        LogManager.i(TAG, "sync time -- baseRealTime:" + this.mBaseRealTime + "===baseNanoTime:" + this.mBaseNanoTime);
    }

    public long getCurrentTime() {
        if (!this.isSync()) {
            long systemTime = System.currentTimeMillis();
            if ((this.mCountNotSync & 0x1F) == 0) {
                LogManager.w(TAG, "no available sync time, use SystemTime instead. SystemTime is: " + systemTime + "| mCountNotSync:" + this.mCountNotSync);
            }
            ++this.mCountNotSync;
            this.mCountNotSync &= Integer.MAX_VALUE;
            return systemTime;
        }
        long nanoTimeNew = Tools.getNanoTime();
        long curTime = this.mBaseRealTime + Tools.getDiffMillsTime(nanoTimeNew, this.mBaseNanoTime);
        return curTime;
    }
}

