/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.ng.common.time.win.timetools;

public class RecycleArray<T> {
    private Object[] mArrays = null;
    private int mHeader = 0;
    private int mTail = 0;
    private int mCapacity = 0;

    public RecycleArray(int capacity) {
        if (capacity == 0) {
            throw new IllegalArgumentException("capacity should be larger than zero.");
        }
        this.mArrays = new Object[capacity + 1];
        this.mCapacity = capacity;
    }

    public boolean isEmpty() {
        return this.mHeader == this.mTail;
    }

    public boolean isFull() {
        return this.mHeader == this.moveNext(this.mTail);
    }

    public void addLast(T t2) {
        if (this.isFull()) {
            this.mHeader = this.moveNext(this.mHeader);
        }
        this.mArrays[this.mTail] = t2;
        this.mTail = this.moveNext(this.mTail);
    }

    public T getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.mArrays[this.movePre(this.mTail)];
    }

    public T getHeader() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.mArrays[this.mHeader];
    }

    public void clearReset() {
        this.mHeader = 0;
        this.mTail = 0;
    }

    public int getCapacity() {
        return this.mCapacity;
    }

    private int moveNext(int index) {
        if (index >= this.mCapacity) {
            return 0;
        }
        return index + 1;
    }

    private int movePre(int index) {
        if (index == 0) {
            return this.mCapacity;
        }
        return index - 1;
    }
}

