/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router;

import android.support.annotation.NonNull;
import com.sankuai.waimai.router.common.PageAnnotationHandler;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.RootUriHandler;
import com.sankuai.waimai.router.core.UriRequest;
import com.sankuai.waimai.router.method.Func0;
import com.sankuai.waimai.router.method.Func1;
import com.sankuai.waimai.router.method.Func2;
import com.sankuai.waimai.router.method.Func3;
import com.sankuai.waimai.router.method.Func4;
import com.sankuai.waimai.router.method.Func5;
import com.sankuai.waimai.router.method.Func6;
import com.sankuai.waimai.router.method.Func7;
import com.sankuai.waimai.router.method.FuncN;
import com.sankuai.waimai.router.service.IFactory;
import com.sankuai.waimai.router.service.ServiceLoader;
import java.util.List;

public class Router {
    private static RootUriHandler rootHandler;

    private Router() {
    }

    public static void init(@NonNull RootUriHandler rootUriHandler) {
        if (rootHandler == null) {
            rootHandler = rootUriHandler;
        } else {
            Debugger.fatal("\u8bf7\u52ff\u91cd\u590d\u521d\u59cb\u5316UriRouter", new Object[0]);
        }
    }

    public static void lazyInit() {
        ServiceLoader.lazyInit();
        Router.getRootHandler().lazyInit();
    }

    public static RootUriHandler getRootHandler() {
        if (rootHandler == null) {
            throw new IllegalStateException("\u8bf7\u5148\u8c03\u7528init\u521d\u59cb\u5316UriRouter");
        }
        return rootHandler;
    }

    public static void startUri(UriRequest request) {
        Router.getRootHandler().startUri(request);
    }

    public static void startUri(f context, String uri) {
        Router.getRootHandler().startUri(new UriRequest(context, uri));
    }

    public static void startPageUri(f context, String path) {
        Router.startUri(context, PageAnnotationHandler.SCHEME_HOST + path);
    }

    public static <T> ServiceLoader<T> loadService(Class<T> clazz) {
        return ServiceLoader.load(clazz);
    }

    public static <I, T extends I> T getService(Class<I> clazz, String key) {
        return ServiceLoader.load(clazz).get(key);
    }

    public static <I, T extends I> T getService(Class<I> clazz, String key, f context) {
        return ServiceLoader.load(clazz).get(key, context);
    }

    public static <I, T extends I> T getService(Class<I> clazz, String key, IFactory factory) {
        return ServiceLoader.load(clazz).get(key, factory);
    }

    public static <I, T extends I> List<T> getAllServices(Class<I> clazz) {
        return ServiceLoader.load(clazz).getAll();
    }

    public static <I, T extends I> List<T> getAllServices(Class<I> clazz, f context) {
        return ServiceLoader.load(clazz).getAll(context);
    }

    public static <I, T extends I> List<T> getAllServices(Class<I> clazz, IFactory factory) {
        return ServiceLoader.load(clazz).getAll(factory);
    }

    public static <I, T extends I> Class<T> getServiceClass(Class<I> clazz, String key) {
        return ServiceLoader.load(clazz).getClass(key);
    }

    public static <I, T extends I> List<Class<T>> getAllServiceClasses(Class<I> clazz) {
        return ServiceLoader.load(clazz).getAllClasses();
    }

    public static <T> T callMethod(String key, Object ... args) {
        switch (args.length) {
            case 0: {
                return (T)((Func0)Router.getService(Func0.class, key)).call();
            }
            case 1: {
                return (T)((Func1)Router.getService(Func1.class, key)).call(args[0]);
            }
            case 2: {
                return (T)((Func2)Router.getService(Func2.class, key)).call(args[0], args[1]);
            }
            case 3: {
                return (T)((Func3)Router.getService(Func3.class, key)).call(args[0], args[1], args[2]);
            }
            case 4: {
                return (T)((Func4)Router.getService(Func4.class, key)).call(args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return (T)((Func5)Router.getService(Func5.class, key)).call(args[0], args[1], args[2], args[3], args[4]);
            }
            case 6: {
                return (T)((Func6)Router.getService(Func6.class, key)).call(args[0], args[1], args[2], args[3], args[4], args[5]);
            }
            case 7: {
                return (T)((Func7)Router.getService(Func7.class, key)).call(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
        }
        return (T)((FuncN)Router.getService(FuncN.class, key)).call(args);
    }
}

