/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.common;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.sankuai.waimai.router.common.PathHandler$1;
import com.sankuai.waimai.router.components.UriTargetTools;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriCallback;
import com.sankuai.waimai.router.core.UriHandler;
import com.sankuai.waimai.router.core.UriInterceptor;
import com.sankuai.waimai.router.core.UriRequest;
import com.sankuai.waimai.router.utils.CaseInsensitiveNonNullMap;
import com.sankuai.waimai.router.utils.RouterUtils;
import java.util.Map;

public class PathHandler
extends UriHandler {
    @NonNull
    private final CaseInsensitiveNonNullMap<UriHandler> mMap = new CaseInsensitiveNonNullMap();
    @Nullable
    private String mPathPrefix;
    @Nullable
    private UriHandler mDefaultHandler = null;

    public void setPathPrefix(@Nullable String pathPrefix) {
        this.mPathPrefix = pathPrefix;
    }

    public PathHandler setDefaultChildHandler(@NonNull UriHandler handler) {
        this.mDefaultHandler = handler;
        return this;
    }

    public void register(String path, Object target, boolean exported, UriInterceptor ... interceptors) {
        UriHandler parse;
        UriHandler prev;
        if (!F.a(path) && (prev = this.mMap.put(path = RouterUtils.appendSlash(path), parse = UriTargetTools.parse(target, exported, interceptors))) != null) {
            Debugger.fatal("[%s] \u91cd\u590d\u6ce8\u518cpath='%s'\u7684UriHandler: %s, %s", this, path, prev, parse);
        }
    }

    public void register(String path, Object handler, UriInterceptor ... interceptors) {
        this.register(path, handler, false, interceptors);
    }

    public void registerAll(Map<String, Object> map) {
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.register(entry.getKey(), entry.getValue(), new UriInterceptor[0]);
            }
        }
    }

    private UriHandler getChild(@NonNull UriRequest request) {
        String path = request.getUri().d();
        if (F.a(path)) {
            return null;
        }
        path = RouterUtils.appendSlash(path);
        if (F.a(this.mPathPrefix)) {
            return this.mMap.get(path);
        }
        if (path.startsWith(this.mPathPrefix)) {
            return this.mMap.get(path.substring(this.mPathPrefix.length()));
        }
        return null;
    }

    @Override
    public boolean shouldHandle(@NonNull UriRequest request) {
        return this.mDefaultHandler != null || this.getChild(request) != null;
    }

    @Override
    public void handleInternal(@NonNull UriRequest request, @NonNull UriCallback callback) {
        UriHandler h2 = this.getChild(request);
        if (h2 != null) {
            h2.handle(request, new PathHandler$1(this, request, callback));
        } else {
            this.handleByDefault(request, callback);
        }
    }

    private void handleByDefault(@NonNull UriRequest request, @NonNull UriCallback callback) {
        UriHandler defaultHandler = this.mDefaultHandler;
        if (defaultHandler != null) {
            defaultHandler.handle(request, callback);
        } else {
            callback.onNext();
        }
    }

    static /* synthetic */ void access$000(PathHandler x0, UriRequest x1, UriCallback x2) {
        x0.handleByDefault(x1, x2);
    }
}

