/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.sankuai.waimai.router.Router;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.OnCompleteListener;
import com.sankuai.waimai.router.utils.RouterUtils;
import java.util.HashMap;
import java.util.Map;

public class UriRequest {
    public static final String FIELD_COMPLETE_LISTENER = "com.sankuai.waimai.router.core.CompleteListener";
    public static final String FIELD_RESULT_CODE = "com.sankuai.waimai.router.core.result";
    public static final String FIELD_ERROR_MSG = "com.sankuai.waimai.router.core.error.msg";
    @NonNull
    private final f mContext;
    @NonNull
    private o mUri;
    @NonNull
    private final Map<String, Object> mFields;
    private boolean isSkipInterceptors = false;
    private String mSchemeHost = null;

    public UriRequest(@NonNull f context, String uri) {
        this(context, UriRequest.parseUriSafely(uri), new HashMap<String, Object>());
    }

    public UriRequest(@NonNull f context, o uri) {
        this(context, uri, new HashMap<String, Object>());
    }

    public UriRequest(@NonNull f context, String uri, Map<String, Object> fields) {
        this(context, UriRequest.parseUriSafely(uri), fields);
    }

    public UriRequest(@NonNull f context, o uri, Map<String, Object> fields) {
        this.mContext = context;
        this.mUri = uri == null ? o.a : uri;
        this.mFields = fields == null ? new HashMap() : fields;
    }

    @NonNull
    public Map<String, Object> getFields() {
        return this.mFields;
    }

    private static o parseUriSafely(@Nullable String uri) {
        return F.a(uri) ? o.a : o.a(uri);
    }

    public UriRequest onComplete(OnCompleteListener listener) {
        this.putField(FIELD_COMPLETE_LISTENER, listener);
        return this;
    }

    public UriRequest setResultCode(int resultCode) {
        this.putField(FIELD_RESULT_CODE, resultCode);
        return this;
    }

    public UriRequest setErrorMessage(String message) {
        this.putField(FIELD_ERROR_MSG, message);
        return this;
    }

    public OnCompleteListener getOnCompleteListener() {
        return this.getField(OnCompleteListener.class, FIELD_COMPLETE_LISTENER);
    }

    public int getResultCode() {
        return this.getIntField(FIELD_RESULT_CODE, 500);
    }

    public String getErrorMessage() {
        return this.getStringField(FIELD_ERROR_MSG, "");
    }

    public String schemeHost() {
        if (this.mSchemeHost == null) {
            this.mSchemeHost = RouterUtils.schemeHost(this.getUri());
        }
        return this.mSchemeHost;
    }

    public boolean isUriEmpty() {
        return o.a.equals(this.mUri);
    }

    @NonNull
    public f getContext() {
        return this.mContext;
    }

    @NonNull
    public o getUri() {
        return this.mUri;
    }

    public void setUri(@NonNull o uri) {
        if (!o.a.equals(uri)) {
            this.mUri = uri;
            this.mSchemeHost = null;
        } else {
            Debugger.fatal("UriRequest.setUri\u4e0d\u5e94\u8be5\u4f20\u5165\u7a7a\u503c", new Object[0]);
        }
    }

    public UriRequest skipInterceptors() {
        this.isSkipInterceptors = true;
        return this;
    }

    public boolean isSkipInterceptors() {
        return this.isSkipInterceptors;
    }

    public <T> UriRequest putField(@NonNull String key, T val) {
        if (val != null) {
            this.mFields.put(key, val);
        }
        return this;
    }

    public synchronized <T> UriRequest putFieldIfAbsent(@NonNull String key, T val) {
        if (val != null && !this.mFields.containsKey(key)) {
            this.mFields.put(key, val);
        }
        return this;
    }

    public UriRequest putFields(Map<String, Object> fields) {
        if (fields != null) {
            this.mFields.putAll(fields);
        }
        return this;
    }

    public boolean hasField(@NonNull String key) {
        return this.mFields.containsKey(key);
    }

    public int getIntField(@NonNull String key, int defaultValue) {
        return this.getField(Integer.class, key, defaultValue);
    }

    public long getLongField(@NonNull String key, long defaultValue) {
        return this.getField(Long.class, key, defaultValue);
    }

    public boolean getBooleanField(@NonNull String key, boolean defaultValue) {
        return this.getField(Boolean.class, key, defaultValue);
    }

    public String getStringField(@NonNull String key) {
        return this.getField(String.class, key, null);
    }

    public String getStringField(@NonNull String key, String defaultValue) {
        return this.getField(String.class, key, defaultValue);
    }

    public <T> T getField(@NonNull Class<T> clazz, @NonNull String key) {
        return this.getField(clazz, key, null);
    }

    public <T> T getField(@NonNull Class<T> clazz, @NonNull String key, T defaultValue) {
        Object field = this.mFields.get(key);
        if (field != null) {
            try {
                return clazz.cast(field);
            }
            catch (ClassCastException e2) {
                Debugger.fatal(e2);
            }
        }
        return defaultValue;
    }

    public void start() {
        Router.startUri(this);
    }

    public String toString() {
        return this.mUri.toString();
    }

    public String toFullString() {
        StringBuilder s2 = new StringBuilder(this.mUri.toString());
        s2.append(", fields = {");
        boolean first = true;
        for (Map.Entry<String, Object> entry : this.mFields.entrySet()) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            s2.append(entry.getKey()).append(" = ").append(entry.getValue());
        }
        s2.append("}");
        return s2.toString();
    }
}

