/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.service;

public class ServiceImpl {
    public static final String SPLITTER = ":";
    public static final String SINGLETON = "singleton";
    private final String key;
    private final String implementation;
    private final Class implementationClazz;
    private final boolean singleton;

    public static String checkConflict(String interfaceName, ServiceImpl impl, ServiceImpl previous) {
        if (impl != null && previous != null && !ServiceImpl.stringEquals(previous.implementation, impl.implementation)) {
            return String.format("\u63a5\u53e3%s\u5bf9\u5e94key='%s'\u5b58\u5728\u591a\u4e2a\u5b9e\u73b0: %s, %s", interfaceName, impl.getKey(), previous, impl);
        }
        return null;
    }

    private static boolean stringEquals(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    private static boolean isEmpty(String key) {
        return key == null || key.length() == 0;
    }

    public ServiceImpl(String key, Class implementation, boolean singleton) {
        if (key == null || implementation == null) {
            throw new RuntimeException("key\u548cimplementation\u4e0d\u5e94\u8be5\u4e3a\u7a7a");
        }
        this.key = key;
        this.implementation = "";
        this.implementationClazz = implementation;
        this.singleton = singleton;
    }

    public ServiceImpl(String key, String implementation, boolean singleton) {
        if (ServiceImpl.isEmpty(implementation)) {
            throw new RuntimeException("implementation\u4e0d\u5e94\u8be5\u4e3a\u7a7a");
        }
        this.key = ServiceImpl.isEmpty(key) ? implementation : key;
        this.implementation = implementation;
        this.implementationClazz = null;
        this.singleton = singleton;
    }

    public String toConfig() {
        String s2 = this.key + SPLITTER + this.implementation;
        if (this.singleton) {
            s2 = s2 + ":singleton";
        }
        return s2;
    }

    public String getKey() {
        return this.key;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public Class getImplementationClazz() {
        return this.implementationClazz;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public String toString() {
        return this.implementation;
    }
}

