/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.SingleConverter;
import io.reactivex.SingleObserver;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleOperator;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import io.reactivex.annotations.BackpressureKind;
import io.reactivex.annotations.BackpressureSupport;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.Experimental;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.SchedulerSupport;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.BooleanSupplier;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function3;
import io.reactivex.functions.Function4;
import io.reactivex.functions.Function5;
import io.reactivex.functions.Function6;
import io.reactivex.functions.Function7;
import io.reactivex.functions.Function8;
import io.reactivex.functions.Function9;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.FuseToFlowable;
import io.reactivex.internal.fuseable.FuseToMaybe;
import io.reactivex.internal.fuseable.FuseToObservable;
import io.reactivex.internal.observers.BiConsumerSingleObserver;
import io.reactivex.internal.observers.BlockingMultiObserver;
import io.reactivex.internal.observers.ConsumerSingleObserver;
import io.reactivex.internal.observers.FutureSingleObserver;
import io.reactivex.internal.operators.completable.CompletableFromSingle;
import io.reactivex.internal.operators.completable.CompletableToFlowable;
import io.reactivex.internal.operators.flowable.FlowableConcatMap;
import io.reactivex.internal.operators.flowable.FlowableConcatMapPublisher;
import io.reactivex.internal.operators.flowable.FlowableFlatMapPublisher;
import io.reactivex.internal.operators.flowable.FlowableSingleSingle;
import io.reactivex.internal.operators.maybe.MaybeFilterSingle;
import io.reactivex.internal.operators.maybe.MaybeFromSingle;
import io.reactivex.internal.operators.observable.ObservableConcatMap;
import io.reactivex.internal.operators.observable.ObservableSingleSingle;
import io.reactivex.internal.operators.single.SingleAmb;
import io.reactivex.internal.operators.single.SingleCache;
import io.reactivex.internal.operators.single.SingleContains;
import io.reactivex.internal.operators.single.SingleCreate;
import io.reactivex.internal.operators.single.SingleDefer;
import io.reactivex.internal.operators.single.SingleDelay;
import io.reactivex.internal.operators.single.SingleDelayWithCompletable;
import io.reactivex.internal.operators.single.SingleDelayWithObservable;
import io.reactivex.internal.operators.single.SingleDelayWithPublisher;
import io.reactivex.internal.operators.single.SingleDelayWithSingle;
import io.reactivex.internal.operators.single.SingleDetach;
import io.reactivex.internal.operators.single.SingleDoAfterSuccess;
import io.reactivex.internal.operators.single.SingleDoAfterTerminate;
import io.reactivex.internal.operators.single.SingleDoFinally;
import io.reactivex.internal.operators.single.SingleDoOnDispose;
import io.reactivex.internal.operators.single.SingleDoOnError;
import io.reactivex.internal.operators.single.SingleDoOnEvent;
import io.reactivex.internal.operators.single.SingleDoOnSubscribe;
import io.reactivex.internal.operators.single.SingleDoOnSuccess;
import io.reactivex.internal.operators.single.SingleEquals;
import io.reactivex.internal.operators.single.SingleError;
import io.reactivex.internal.operators.single.SingleFlatMap;
import io.reactivex.internal.operators.single.SingleFlatMapCompletable;
import io.reactivex.internal.operators.single.SingleFlatMapIterableFlowable;
import io.reactivex.internal.operators.single.SingleFlatMapIterableObservable;
import io.reactivex.internal.operators.single.SingleFlatMapMaybe;
import io.reactivex.internal.operators.single.SingleFromCallable;
import io.reactivex.internal.operators.single.SingleFromPublisher;
import io.reactivex.internal.operators.single.SingleFromUnsafeSource;
import io.reactivex.internal.operators.single.SingleHide;
import io.reactivex.internal.operators.single.SingleInternalHelper;
import io.reactivex.internal.operators.single.SingleJust;
import io.reactivex.internal.operators.single.SingleLift;
import io.reactivex.internal.operators.single.SingleMap;
import io.reactivex.internal.operators.single.SingleNever;
import io.reactivex.internal.operators.single.SingleObserveOn;
import io.reactivex.internal.operators.single.SingleOnErrorReturn;
import io.reactivex.internal.operators.single.SingleResumeNext;
import io.reactivex.internal.operators.single.SingleSubscribeOn;
import io.reactivex.internal.operators.single.SingleTakeUntil;
import io.reactivex.internal.operators.single.SingleTimeout;
import io.reactivex.internal.operators.single.SingleTimer;
import io.reactivex.internal.operators.single.SingleToFlowable;
import io.reactivex.internal.operators.single.SingleToObservable;
import io.reactivex.internal.operators.single.SingleUnsubscribeOn;
import io.reactivex.internal.operators.single.SingleUsing;
import io.reactivex.internal.operators.single.SingleZipArray;
import io.reactivex.internal.operators.single.SingleZipIterable;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.observers.TestObserver;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class Single<T>
implements SingleSource<T> {
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> amb(Iterable<? extends SingleSource<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new SingleAmb(null, sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> ambArray(SingleSource<? extends T> ... sources) {
        if (sources.length == 0) {
            return Single.error(SingleInternalHelper.emptyThrower());
        }
        if (sources.length == 1) {
            return Single.wrap(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new SingleAmb<T>(sources, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T> Flowable<T> concat(Iterable<? extends SingleSource<? extends T>> sources) {
        return Single.concat(Flowable.fromIterable(sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Observable<T> concat(ObservableSource<? extends SingleSource<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new ObservableConcatMap(sources, SingleInternalHelper.toObservable(), 2, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Yw<? extends SingleSource<? extends T>> sources) {
        return Single.concat(sources, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Yw<? extends SingleSource<? extends T>> sources, int prefetch) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapPublisher(sources, SingleInternalHelper.toFlowable(), prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(SingleSource<? extends T> source1, SingleSource<? extends T> source2) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        return Single.concat(Flowable.fromArray(source1, source2));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(SingleSource<? extends T> source1, SingleSource<? extends T> source2, SingleSource<? extends T> source3) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        return Single.concat(Flowable.fromArray(source1, source2, source3));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(SingleSource<? extends T> source1, SingleSource<? extends T> source2, SingleSource<? extends T> source3, SingleSource<? extends T> source4) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        return Single.concat(Flowable.fromArray(source1, source2, source3, source4));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatArray(SingleSource<? extends T> ... sources) {
        return RxJavaPlugins.onAssembly(new FlowableConcatMap(Flowable.fromArray(sources), SingleInternalHelper.toFlowable(), 2, ErrorMode.BOUNDARY));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> create(SingleOnSubscribe<T> source) {
        ObjectHelper.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new SingleCreate<T>(source));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> defer(Callable<? extends SingleSource<? extends T>> singleSupplier) {
        ObjectHelper.requireNonNull(singleSupplier, "singleSupplier is null");
        return RxJavaPlugins.onAssembly(new SingleDefer(singleSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> error(Callable<? extends Throwable> errorSupplier) {
        ObjectHelper.requireNonNull(errorSupplier, "errorSupplier is null");
        return RxJavaPlugins.onAssembly(new SingleError(errorSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> error(Throwable exception) {
        ObjectHelper.requireNonNull(exception, "error is null");
        return Single.error(Functions.justCallable(exception));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> fromCallable(Callable<? extends T> callable) {
        ObjectHelper.requireNonNull(callable, "callable is null");
        return RxJavaPlugins.onAssembly(new SingleFromCallable<T>(callable));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> fromFuture(Future<? extends T> future) {
        return Single.toSingle(Flowable.fromFuture(future));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> fromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        return Single.toSingle(Flowable.fromFuture(future, timeout, unit));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    public static <T> Single<T> fromFuture(Future<? extends T> future, long timeout, TimeUnit unit, Scheduler scheduler) {
        return Single.toSingle(Flowable.fromFuture(future, timeout, unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    public static <T> Single<T> fromFuture(Future<? extends T> future, Scheduler scheduler) {
        return Single.toSingle(Flowable.fromFuture(future, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> fromPublisher(Yw<? extends T> publisher) {
        ObjectHelper.requireNonNull(publisher, "publisher is null");
        return RxJavaPlugins.onAssembly(new SingleFromPublisher<T>(publisher));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> fromObservable(ObservableSource<? extends T> observableSource) {
        ObjectHelper.requireNonNull(observableSource, "observableSource is null");
        return RxJavaPlugins.onAssembly(new ObservableSingleSingle<Object>(observableSource, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> just(T item) {
        ObjectHelper.requireNonNull(item, "value is null");
        return RxJavaPlugins.onAssembly(new SingleJust<T>(item));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Iterable<? extends SingleSource<? extends T>> sources) {
        return Single.merge(Flowable.fromIterable(sources));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Yw<? extends SingleSource<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableFlatMapPublisher(sources, SingleInternalHelper.toFlowable(), false, Integer.MAX_VALUE, Flowable.bufferSize()));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> merge(SingleSource<? extends SingleSource<? extends T>> source) {
        ObjectHelper.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMap(source, Functions.identity()));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(SingleSource<? extends T> source1, SingleSource<? extends T> source2) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        return Single.merge(Flowable.fromArray(source1, source2));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(SingleSource<? extends T> source1, SingleSource<? extends T> source2, SingleSource<? extends T> source3) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        return Single.merge(Flowable.fromArray(source1, source2, source3));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(SingleSource<? extends T> source1, SingleSource<? extends T> source2, SingleSource<? extends T> source3, SingleSource<? extends T> source4) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        return Single.merge(Flowable.fromArray(source1, source2, source3, source4));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @Experimental
    public static <T> Flowable<T> mergeDelayError(Iterable<? extends SingleSource<? extends T>> sources) {
        return Single.mergeDelayError(Flowable.fromIterable(sources));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @Experimental
    public static <T> Flowable<T> mergeDelayError(Yw<? extends SingleSource<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableFlatMapPublisher(sources, SingleInternalHelper.toFlowable(), true, Integer.MAX_VALUE, Flowable.bufferSize()));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @Experimental
    public static <T> Flowable<T> mergeDelayError(SingleSource<? extends T> source1, SingleSource<? extends T> source2) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        return Single.mergeDelayError(Flowable.fromArray(source1, source2));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @Experimental
    public static <T> Flowable<T> mergeDelayError(SingleSource<? extends T> source1, SingleSource<? extends T> source2, SingleSource<? extends T> source3) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        return Single.mergeDelayError(Flowable.fromArray(source1, source2, source3));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @Experimental
    public static <T> Flowable<T> mergeDelayError(SingleSource<? extends T> source1, SingleSource<? extends T> source2, SingleSource<? extends T> source3, SingleSource<? extends T> source4) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        return Single.mergeDelayError(Flowable.fromArray(source1, source2, source3, source4));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> never() {
        return RxJavaPlugins.onAssembly(SingleNever.INSTANCE);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    public static Single<Long> timer(long delay, TimeUnit unit) {
        return Single.timer(delay, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    public static Single<Long> timer(long delay, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleTimer(delay, unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<Boolean> equals(SingleSource<? extends T> first, SingleSource<? extends T> second) {
        ObjectHelper.requireNonNull(first, "first is null");
        ObjectHelper.requireNonNull(second, "second is null");
        return RxJavaPlugins.onAssembly(new SingleEquals<T>(first, second));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> unsafeCreate(SingleSource<T> onSubscribe) {
        ObjectHelper.requireNonNull(onSubscribe, "onSubscribe is null");
        if (onSubscribe instanceof Single) {
            throw new IllegalArgumentException("unsafeCreate(Single) should be upgraded");
        }
        return RxJavaPlugins.onAssembly(new SingleFromUnsafeSource<T>(onSubscribe));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T, U> Single<T> using(Callable<U> resourceSupplier, Function<? super U, ? extends SingleSource<? extends T>> singleFunction, Consumer<? super U> disposer) {
        return Single.using(resourceSupplier, singleFunction, disposer, true);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T, U> Single<T> using(Callable<U> resourceSupplier, Function<? super U, ? extends SingleSource<? extends T>> singleFunction, Consumer<? super U> disposer, boolean eager) {
        ObjectHelper.requireNonNull(resourceSupplier, "resourceSupplier is null");
        ObjectHelper.requireNonNull(singleFunction, "singleFunction is null");
        ObjectHelper.requireNonNull(disposer, "disposer is null");
        return RxJavaPlugins.onAssembly(new SingleUsing(resourceSupplier, singleFunction, disposer, eager));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T> Single<T> wrap(SingleSource<T> source) {
        ObjectHelper.requireNonNull(source, "source is null");
        if (source instanceof Single) {
            return RxJavaPlugins.onAssembly((Single)source);
        }
        return RxJavaPlugins.onAssembly(new SingleFromUnsafeSource<T>(source));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T, R> Single<R> zip(Iterable<? extends SingleSource<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new SingleZipIterable(sources, zipper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T1, T2, R> Single<R> zip(SingleSource<? extends T1> source1, SingleSource<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, R> Single<R> zip(SingleSource<? extends T1> source1, SingleSource<? extends T2> source2, SingleSource<? extends T3> source3, Function3<? super T1, ? super T2, ? super T3, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, R> Single<R> zip(SingleSource<? extends T1> source1, SingleSource<? extends T2> source2, SingleSource<? extends T3> source3, SingleSource<? extends T4> source4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, R> Single<R> zip(SingleSource<? extends T1> source1, SingleSource<? extends T2> source2, SingleSource<? extends T3> source3, SingleSource<? extends T4> source4, SingleSource<? extends T5> source5, Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4, source5);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, R> Single<R> zip(SingleSource<? extends T1> source1, SingleSource<? extends T2> source2, SingleSource<? extends T3> source3, SingleSource<? extends T4> source4, SingleSource<? extends T5> source5, SingleSource<? extends T6> source6, Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4, source5, source6);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, R> Single<R> zip(SingleSource<? extends T1> source1, SingleSource<? extends T2> source2, SingleSource<? extends T3> source3, SingleSource<? extends T4> source4, SingleSource<? extends T5> source5, SingleSource<? extends T6> source6, SingleSource<? extends T7> source7, Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        ObjectHelper.requireNonNull(source7, "source7 is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4, source5, source6, source7);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Single<R> zip(SingleSource<? extends T1> source1, SingleSource<? extends T2> source2, SingleSource<? extends T3> source3, SingleSource<? extends T4> source4, SingleSource<? extends T5> source5, SingleSource<? extends T6> source6, SingleSource<? extends T7> source7, SingleSource<? extends T8> source8, Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        ObjectHelper.requireNonNull(source7, "source7 is null");
        ObjectHelper.requireNonNull(source8, "source8 is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4, source5, source6, source7, source8);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Single<R> zip(SingleSource<? extends T1> source1, SingleSource<? extends T2> source2, SingleSource<? extends T3> source3, SingleSource<? extends T4> source4, SingleSource<? extends T5> source5, SingleSource<? extends T6> source6, SingleSource<? extends T7> source7, SingleSource<? extends T8> source8, SingleSource<? extends T9> source9, Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        ObjectHelper.requireNonNull(source7, "source7 is null");
        ObjectHelper.requireNonNull(source8, "source8 is null");
        ObjectHelper.requireNonNull(source9, "source9 is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4, source5, source6, source7, source8, source9);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public static <T, R> Single<R> zipArray(Function<? super Object[], ? extends R> zipper, SingleSource<? extends T> ... sources) {
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        ObjectHelper.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Single.error(new NoSuchElementException());
        }
        return RxJavaPlugins.onAssembly(new SingleZipArray<T, R>(sources, zipper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> ambWith(SingleSource<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return Single.ambArray(this, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @Experimental
    public final <R> R as(@NonNull SingleConverter<T, ? extends R> converter) {
        return ObjectHelper.requireNonNull(converter, "converter is null").apply(this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> hide() {
        return RxJavaPlugins.onAssembly(new SingleHide(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <R> Single<R> compose(SingleTransformer<? super T, ? extends R> transformer) {
        return Single.wrap(ObjectHelper.requireNonNull(transformer, "transformer is null").apply(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> cache() {
        return RxJavaPlugins.onAssembly(new SingleCache(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <U> Single<U> cast(Class<? extends U> clazz) {
        ObjectHelper.requireNonNull(clazz, "clazz is null");
        return this.map(Functions.castFunction(clazz));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Flowable<T> concatWith(SingleSource<? extends T> other) {
        return Single.concat(this, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    public final Single<T> delay(long time, TimeUnit unit) {
        return this.delay(time, unit, Schedulers.computation(), false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @Experimental
    public final Single<T> delay(long time, TimeUnit unit, boolean delayError) {
        return this.delay(time, unit, Schedulers.computation(), delayError);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    public final Single<T> delay(long time, TimeUnit unit, Scheduler scheduler) {
        return this.delay(time, unit, scheduler, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @Experimental
    public final Single<T> delay(long time, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleDelay(this, time, unit, scheduler, delayError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> delaySubscription(CompletableSource other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new SingleDelayWithCompletable(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <U> Single<T> delaySubscription(SingleSource<U> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new SingleDelayWithSingle(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <U> Single<T> delaySubscription(ObservableSource<U> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new SingleDelayWithObservable(this, other));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <U> Single<T> delaySubscription(Yw<U> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new SingleDelayWithPublisher(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    public final Single<T> delaySubscription(long time, TimeUnit unit) {
        return this.delaySubscription(time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    public final Single<T> delaySubscription(long time, TimeUnit unit, Scheduler scheduler) {
        return this.delaySubscription(Observable.timer(time, unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> doAfterSuccess(Consumer<? super T> onAfterSuccess) {
        ObjectHelper.requireNonNull(onAfterSuccess, "doAfterSuccess is null");
        return RxJavaPlugins.onAssembly(new SingleDoAfterSuccess<T>(this, onAfterSuccess));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> doAfterTerminate(Action onAfterTerminate) {
        ObjectHelper.requireNonNull(onAfterTerminate, "onAfterTerminate is null");
        return RxJavaPlugins.onAssembly(new SingleDoAfterTerminate(this, onAfterTerminate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> doFinally(Action onFinally) {
        ObjectHelper.requireNonNull(onFinally, "onFinally is null");
        return RxJavaPlugins.onAssembly(new SingleDoFinally(this, onFinally));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> doOnSubscribe(Consumer<? super Disposable> onSubscribe) {
        ObjectHelper.requireNonNull(onSubscribe, "onSubscribe is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnSubscribe(this, onSubscribe));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> doOnSuccess(Consumer<? super T> onSuccess) {
        ObjectHelper.requireNonNull(onSuccess, "onSuccess is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnSuccess<T>(this, onSuccess));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> doOnEvent(BiConsumer<? super T, ? super Throwable> onEvent) {
        ObjectHelper.requireNonNull(onEvent, "onEvent is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnEvent<T>(this, onEvent));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> doOnError(Consumer<? super Throwable> onError) {
        ObjectHelper.requireNonNull(onError, "onError is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnError(this, onError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> doOnDispose(Action onDispose) {
        ObjectHelper.requireNonNull(onDispose, "onDispose is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnDispose(this, onDispose));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Maybe<T> filter(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new MaybeFilterSingle<T>(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <R> Single<R> flatMap(Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMap(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <R> Maybe<R> flatMapMaybe(Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapMaybe(this, mapper));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMapPublisher(Function<? super T, ? extends Yw<? extends R>> mapper) {
        return this.toFlowable().flatMap(mapper);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> flattenAsFlowable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapIterableFlowable(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <U> Observable<U> flattenAsObservable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapIterableObservable(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <R> Observable<R> flatMapObservable(Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.toObservable().flatMap(mapper);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Completable flatMapCompletable(Function<? super T, ? extends CompletableSource> mapper) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapCompletable<T>(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final T blockingGet() {
        BlockingMultiObserver observer = new BlockingMultiObserver();
        this.subscribe(observer);
        return observer.blockingGet();
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <R> Single<R> lift(SingleOperator<? extends R, ? super T> lift) {
        ObjectHelper.requireNonNull(lift, "onLift is null");
        return RxJavaPlugins.onAssembly(new SingleLift<T, R>(this, lift));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <R> Single<R> map(Function<? super T, ? extends R> mapper) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleMap<T, R>(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<Boolean> contains(Object value) {
        return this.contains(value, ObjectHelper.equalsPredicate());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<Boolean> contains(Object value, BiPredicate<Object, Object> comparer) {
        ObjectHelper.requireNonNull(value, "value is null");
        ObjectHelper.requireNonNull(comparer, "comparer is null");
        return RxJavaPlugins.onAssembly(new SingleContains(this, value, comparer));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Flowable<T> mergeWith(SingleSource<? extends T> other) {
        return Single.merge(this, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    public final Single<T> observeOn(Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleObserveOn(this, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> onErrorReturn(Function<Throwable, ? extends T> resumeFunction) {
        ObjectHelper.requireNonNull(resumeFunction, "resumeFunction is null");
        return RxJavaPlugins.onAssembly(new SingleOnErrorReturn<Object>(this, resumeFunction, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> onErrorReturnItem(T value) {
        ObjectHelper.requireNonNull(value, "value is null");
        return RxJavaPlugins.onAssembly(new SingleOnErrorReturn<T>(this, null, value));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> onErrorResumeNext(Single<? extends T> resumeSingleInCaseOfError) {
        ObjectHelper.requireNonNull(resumeSingleInCaseOfError, "resumeSingleInCaseOfError is null");
        return this.onErrorResumeNext(Functions.justFunction(resumeSingleInCaseOfError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> onErrorResumeNext(Function<? super Throwable, ? extends SingleSource<? extends T>> resumeFunctionInCaseOfError) {
        ObjectHelper.requireNonNull(resumeFunctionInCaseOfError, "resumeFunctionInCaseOfError is null");
        return RxJavaPlugins.onAssembly(new SingleResumeNext(this, resumeFunctionInCaseOfError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @Experimental
    public final Single<T> onTerminateDetach() {
        return RxJavaPlugins.onAssembly(new SingleDetach(this));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Flowable<T> repeat() {
        return this.toFlowable().repeat();
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Flowable<T> repeat(long times) {
        return this.toFlowable().repeat(times);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Flowable<T> repeatWhen(Function<? super Flowable<Object>, ? extends Yw<?>> handler) {
        return this.toFlowable().repeatWhen(handler);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Flowable<T> repeatUntil(BooleanSupplier stop) {
        return this.toFlowable().repeatUntil(stop);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> retry() {
        return Single.toSingle(this.toFlowable().retry());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> retry(long times) {
        return Single.toSingle(this.toFlowable().retry(times));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> retry(BiPredicate<? super Integer, ? super Throwable> predicate) {
        return Single.toSingle(this.toFlowable().retry(predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @Experimental
    public final Single<T> retry(long times, Predicate<? super Throwable> predicate) {
        return Single.toSingle(this.toFlowable().retry(times, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> retry(Predicate<? super Throwable> predicate) {
        return Single.toSingle(this.toFlowable().retry(predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> retryWhen(Function<? super Flowable<Throwable>, ? extends Yw<?>> handler) {
        return Single.toSingle(this.toFlowable().retryWhen(handler));
    }

    @SchedulerSupport(value="none")
    public final Disposable subscribe() {
        return this.subscribe(Functions.emptyConsumer(), Functions.ON_ERROR_MISSING);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Disposable subscribe(BiConsumer<? super T, ? super Throwable> onCallback) {
        ObjectHelper.requireNonNull(onCallback, "onCallback is null");
        BiConsumerSingleObserver<? super T> s2 = new BiConsumerSingleObserver<T>(onCallback);
        this.subscribe(s2);
        return s2;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onSuccess) {
        return this.subscribe(onSuccess, Functions.ON_ERROR_MISSING);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onSuccess, Consumer<? super Throwable> onError) {
        ObjectHelper.requireNonNull(onSuccess, "onSuccess is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ConsumerSingleObserver<? super T> s2 = new ConsumerSingleObserver<T>(onSuccess, onError);
        this.subscribe(s2);
        return s2;
    }

    @Override
    @SchedulerSupport(value="none")
    public final void subscribe(SingleObserver<? super T> subscriber) {
        ObjectHelper.requireNonNull(subscriber, "subscriber is null");
        subscriber = RxJavaPlugins.onSubscribe(this, subscriber);
        ObjectHelper.requireNonNull(subscriber, "subscriber returned by the RxJavaPlugins hook is null");
        try {
            this.subscribeActual(subscriber);
        }
        catch (NullPointerException ex2) {
            throw ex2;
        }
        catch (Throwable ex3) {
            Exceptions.throwIfFatal(ex3);
            NullPointerException npe = new NullPointerException("subscribeActual failed");
            npe.initCause(ex3);
            throw npe;
        }
    }

    protected abstract void subscribeActual(@NonNull SingleObserver<? super T> var1);

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <E extends SingleObserver<? super T>> E subscribeWith(E observer) {
        this.subscribe(observer);
        return observer;
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    public final Single<T> subscribeOn(Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleSubscribeOn(this, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Single<T> takeUntil(CompletableSource other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return this.takeUntil(new CompletableToFlowable(other));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <E> Single<T> takeUntil(Yw<E> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new SingleTakeUntil(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <E> Single<T> takeUntil(SingleSource<? extends E> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return this.takeUntil(new SingleToFlowable<E>(other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    public final Single<T> timeout(long timeout, TimeUnit unit) {
        return this.timeout0(timeout, unit, Schedulers.computation(), null);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    public final Single<T> timeout(long timeout, TimeUnit unit, Scheduler scheduler) {
        return this.timeout0(timeout, unit, scheduler, null);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    public final Single<T> timeout(long timeout, TimeUnit unit, Scheduler scheduler, SingleSource<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return this.timeout0(timeout, unit, scheduler, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    public final Single<T> timeout(long timeout, TimeUnit unit, SingleSource<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return this.timeout0(timeout, unit, Schedulers.computation(), other);
    }

    private Single<T> timeout0(long timeout, TimeUnit unit, Scheduler scheduler, SingleSource<? extends T> other) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleTimeout<T>(this, timeout, unit, scheduler, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <R> R to(Function<? super Single<T>, R> convert) {
        try {
            return ObjectHelper.requireNonNull(convert, "convert is null").apply(this);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            throw ExceptionHelper.wrapOrThrow(ex2);
        }
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Completable toCompletable() {
        return RxJavaPlugins.onAssembly(new CompletableFromSingle(this));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Flowable<T> toFlowable() {
        if (this instanceof FuseToFlowable) {
            return ((FuseToFlowable)((Object)this)).fuseToFlowable();
        }
        return RxJavaPlugins.onAssembly(new SingleToFlowable(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Future<T> toFuture() {
        return this.subscribeWith(new FutureSingleObserver());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Maybe<T> toMaybe() {
        if (this instanceof FuseToMaybe) {
            return ((FuseToMaybe)((Object)this)).fuseToMaybe();
        }
        return RxJavaPlugins.onAssembly(new MaybeFromSingle(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final Observable<T> toObservable() {
        if (this instanceof FuseToObservable) {
            return ((FuseToObservable)((Object)this)).fuseToObservable();
        }
        return RxJavaPlugins.onAssembly(new SingleToObservable(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @Experimental
    public final Single<T> unsubscribeOn(Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleUnsubscribeOn(this, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <U, R> Single<R> zipWith(SingleSource<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return Single.zip(this, other, zipper);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final TestObserver<T> test() {
        TestObserver ts2 = new TestObserver();
        this.subscribe(ts2);
        return ts2;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final TestObserver<T> test(boolean cancelled) {
        TestObserver ts2 = new TestObserver();
        if (cancelled) {
            ts2.cancel();
        }
        this.subscribe(ts2);
        return ts2;
    }

    private static <T> Single<T> toSingle(Flowable<T> source) {
        return RxJavaPlugins.onAssembly(new FlowableSingleSingle<Object>(source, null));
    }
}

