/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.disposables;

import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableContainer;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.OpenHashSet;
import java.util.ArrayList;

public final class CompositeDisposable
implements Disposable,
DisposableContainer {
    OpenHashSet<Disposable> resources;
    volatile boolean disposed;

    public CompositeDisposable() {
    }

    public CompositeDisposable(Disposable ... resources) {
        ObjectHelper.requireNonNull(resources, "resources is null");
        this.resources = new OpenHashSet(resources.length + 1);
        for (Disposable d2 : resources) {
            ObjectHelper.requireNonNull(d2, "Disposable item is null");
            this.resources.add(d2);
        }
    }

    public CompositeDisposable(@NonNull Iterable<? extends Disposable> resources) {
        ObjectHelper.requireNonNull(resources, "resources is null");
        this.resources = new OpenHashSet();
        for (Disposable disposable : resources) {
            ObjectHelper.requireNonNull(disposable, "Disposable item is null");
            this.resources.add(disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        OpenHashSet<Disposable> set;
        if (this.disposed) {
            return;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(@NonNull Disposable d2) {
        ObjectHelper.requireNonNull(d2, "d is null");
        if (!this.disposed) {
            CompositeDisposable compositeDisposable = this;
            synchronized (compositeDisposable) {
                if (!this.disposed) {
                    OpenHashSet<Disposable> set = this.resources;
                    if (set == null) {
                        this.resources = set = new OpenHashSet();
                    }
                    set.add(d2);
                    return true;
                }
            }
        }
        d2.dispose();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Disposable ... ds2) {
        ObjectHelper.requireNonNull(ds2, "ds is null");
        if (!this.disposed) {
            CompositeDisposable object = this;
            synchronized (object) {
                if (!this.disposed) {
                    OpenHashSet<Disposable> set = this.resources;
                    if (set == null) {
                        set = new OpenHashSet(ds2.length + 1);
                        this.resources = set;
                    }
                    for (Disposable d2 : ds2) {
                        ObjectHelper.requireNonNull(d2, "d is null");
                        set.add(d2);
                    }
                    return true;
                }
            }
        }
        for (Disposable d3 : ds2) {
            d3.dispose();
        }
        return false;
    }

    @Override
    public boolean remove(@NonNull Disposable d2) {
        if (this.delete(d2)) {
            d2.dispose();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(@NonNull Disposable d2) {
        ObjectHelper.requireNonNull(d2, "Disposable item is null");
        if (this.disposed) {
            return false;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return false;
            }
            OpenHashSet<Disposable> set = this.resources;
            if (set == null || !set.remove(d2)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        OpenHashSet<Disposable> set;
        if (this.disposed) {
            return;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return;
            }
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.disposed) {
            return 0;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return 0;
            }
            OpenHashSet<Disposable> set = this.resources;
            int n2 = set != null ? set.size() : 0;
            return n2;
        }
    }

    void dispose(OpenHashSet<Disposable> set) {
        Object[] array;
        if (set == null) {
            return;
        }
        ArrayList<Throwable> errors = null;
        for (Object o2 : array = set.keys()) {
            if (!(o2 instanceof Disposable)) continue;
            try {
                ((Disposable)o2).dispose();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                if (errors == null) {
                    errors = new ArrayList<Throwable>();
                }
                errors.add(ex2);
            }
        }
        if (errors != null) {
            if (errors.size() == 1) {
                throw ExceptionHelper.wrapOrThrow((Throwable)errors.get(0));
            }
            throw new CompositeException((Iterable<? extends Throwable>)errors);
        }
    }
}

