/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.disposables;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ArrayCompositeDisposable
extends AtomicReferenceArray<Disposable>
implements Disposable {
    private static final long serialVersionUID = 2746389416410565408L;

    public ArrayCompositeDisposable(int capacity) {
        super(capacity);
    }

    public boolean setResource(int index, Disposable resource) {
        Disposable o2;
        do {
            if ((o2 = (Disposable)this.get(index)) != DisposableHelper.DISPOSED) continue;
            resource.dispose();
            return false;
        } while (!this.compareAndSet(index, o2, resource));
        if (o2 != null) {
            o2.dispose();
        }
        return true;
    }

    public Disposable replaceResource(int index, Disposable resource) {
        Disposable o2;
        do {
            if ((o2 = (Disposable)this.get(index)) != DisposableHelper.DISPOSED) continue;
            resource.dispose();
            return null;
        } while (!this.compareAndSet(index, o2, resource));
        return o2;
    }

    @Override
    public void dispose() {
        if (this.get(0) != DisposableHelper.DISPOSED) {
            int s2 = this.length();
            for (int i2 = 0; i2 < s2; ++i2) {
                Disposable o2 = (Disposable)this.get(i2);
                if (o2 == DisposableHelper.DISPOSED || (o2 = (Disposable)this.getAndSet(i2, DisposableHelper.DISPOSED)) == DisposableHelper.DISPOSED || o2 == null) continue;
                o2.dispose();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.get(0) == DisposableHelper.DISPOSED;
    }
}

