/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.disposables;

import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableContainer;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class ListCompositeDisposable
implements Disposable,
DisposableContainer {
    List<Disposable> resources;
    volatile boolean disposed;

    public ListCompositeDisposable() {
    }

    public ListCompositeDisposable(Disposable ... resources) {
        ObjectHelper.requireNonNull(resources, "resources is null");
        this.resources = new LinkedList<Disposable>();
        for (Disposable d2 : resources) {
            ObjectHelper.requireNonNull(d2, "Disposable item is null");
            this.resources.add(d2);
        }
    }

    public ListCompositeDisposable(Iterable<? extends Disposable> resources) {
        ObjectHelper.requireNonNull(resources, "resources is null");
        this.resources = new LinkedList<Disposable>();
        for (Disposable disposable : resources) {
            ObjectHelper.requireNonNull(disposable, "Disposable item is null");
            this.resources.add(disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<Disposable> set;
        if (this.disposed) {
            return;
        }
        ListCompositeDisposable listCompositeDisposable = this;
        synchronized (listCompositeDisposable) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Disposable d2) {
        ObjectHelper.requireNonNull(d2, "d is null");
        if (!this.disposed) {
            ListCompositeDisposable listCompositeDisposable = this;
            synchronized (listCompositeDisposable) {
                if (!this.disposed) {
                    List<Disposable> set = this.resources;
                    if (set == null) {
                        this.resources = set = new LinkedList<Disposable>();
                    }
                    set.add(d2);
                    return true;
                }
            }
        }
        d2.dispose();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Disposable ... ds2) {
        ObjectHelper.requireNonNull(ds2, "ds is null");
        if (!this.disposed) {
            ListCompositeDisposable object = this;
            synchronized (object) {
                if (!this.disposed) {
                    List<Disposable> set = this.resources;
                    if (set == null) {
                        this.resources = set = new LinkedList<Disposable>();
                    }
                    for (Disposable d2 : ds2) {
                        ObjectHelper.requireNonNull(d2, "d is null");
                        set.add(d2);
                    }
                    return true;
                }
            }
        }
        for (Disposable d3 : ds2) {
            d3.dispose();
        }
        return false;
    }

    @Override
    public boolean remove(Disposable d2) {
        if (this.delete(d2)) {
            d2.dispose();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Disposable d2) {
        ObjectHelper.requireNonNull(d2, "Disposable item is null");
        if (this.disposed) {
            return false;
        }
        ListCompositeDisposable listCompositeDisposable = this;
        synchronized (listCompositeDisposable) {
            if (this.disposed) {
                return false;
            }
            List<Disposable> set = this.resources;
            if (set == null || !set.remove(d2)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Disposable> set;
        if (this.disposed) {
            return;
        }
        ListCompositeDisposable listCompositeDisposable = this;
        synchronized (listCompositeDisposable) {
            if (this.disposed) {
                return;
            }
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    void dispose(List<Disposable> set) {
        if (set == null) {
            return;
        }
        ArrayList<Throwable> errors = null;
        for (Disposable o2 : set) {
            try {
                o2.dispose();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                if (errors == null) {
                    errors = new ArrayList<Throwable>();
                }
                errors.add(ex2);
            }
        }
        if (errors != null) {
            if (errors.size() == 1) {
                throw ExceptionHelper.wrapOrThrow((Throwable)errors.get(0));
            }
            throw new CompositeException((Iterable<? extends Throwable>)errors);
        }
    }
}

