/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.observers;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class ForEachWhileObserver<T>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -4403180040475402120L;
    final Predicate<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    boolean done;

    public ForEachWhileObserver(Predicate<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        DisposableHelper.setOnce(this, s2);
    }

    @Override
    public void onNext(T t2) {
        boolean b2;
        if (this.done) {
            return;
        }
        try {
            b2 = this.onNext.test(t2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.dispose();
            this.onError(ex2);
            return;
        }
        if (!b2) {
            this.dispose();
            this.onComplete();
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        try {
            this.onError.accept(t2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            RxJavaPlugins.onError(new CompositeException(t2, ex2));
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.onComplete.run();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            RxJavaPlugins.onError(ex2);
        }
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }
}

