/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.observers;

import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class FutureSingleObserver<T>
extends CountDownLatch
implements SingleObserver<T>,
Disposable,
Future<T> {
    T value;
    Throwable error;
    final AtomicReference<Disposable> s = new AtomicReference();

    public FutureSingleObserver() {
        super(1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Disposable a2;
        do {
            if ((a2 = this.s.get()) != this && a2 != DisposableHelper.DISPOSED) continue;
            return false;
        } while (!this.s.compareAndSet(a2, DisposableHelper.DISPOSED));
        if (a2 != null) {
            a2.dispose();
        }
        this.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return DisposableHelper.isDisposed(this.s.get());
    }

    @Override
    public boolean isDone() {
        return this.getCount() == 0L;
    }

    @Override
    public T get() {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            this.await();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex2 = this.error;
        if (ex2 != null) {
            throw new ExecutionException(ex2);
        }
        return this.value;
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            if (!this.await(timeout, unit)) {
                throw new TimeoutException();
            }
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex2 = this.error;
        if (ex2 != null) {
            throw new ExecutionException(ex2);
        }
        return this.value;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        DisposableHelper.setOnce(this.s, s2);
    }

    @Override
    public void onSuccess(T t2) {
        Disposable a2 = this.s.get();
        if (a2 == DisposableHelper.DISPOSED) {
            return;
        }
        this.value = t2;
        this.s.compareAndSet(a2, this);
        this.countDown();
    }

    @Override
    public void onError(Throwable t2) {
        Disposable a2;
        do {
            if ((a2 = this.s.get()) == DisposableHelper.DISPOSED) {
                RxJavaPlugins.onError(t2);
                return;
            }
            this.error = t2;
        } while (!this.s.compareAndSet(a2, this));
        this.countDown();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return this.isDone();
    }
}

