/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.observers;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.Functions;
import io.reactivex.observers.LambdaConsumerIntrospection;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class LambdaObserver<T>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable,
LambdaConsumerIntrospection {
    private static final long serialVersionUID = -7251123623727029452L;
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Consumer<? super Disposable> onSubscribe;

    public LambdaObserver(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Consumer<? super Disposable> onSubscribe) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onSubscribe = onSubscribe;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.setOnce(this, s2)) {
            try {
                this.onSubscribe.accept(this);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                s2.dispose();
                this.onError(ex2);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.isDisposed()) {
            try {
                this.onNext.accept(t2);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                ((Disposable)this.get()).dispose();
                this.onError(e2);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.isDisposed()) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.onError.accept(t2);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                RxJavaPlugins.onError(new CompositeException(t2, e2));
            }
        }
    }

    @Override
    public void onComplete() {
        if (!this.isDisposed()) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.onComplete.run();
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                RxJavaPlugins.onError(e2);
            }
        }
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == DisposableHelper.DISPOSED;
    }

    @Override
    public boolean hasCustomOnError() {
        return this.onError != Functions.ON_ERROR_MISSING;
    }
}

