/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.observers;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.observers.QueueDrainSubscriberPad2;
import io.reactivex.internal.util.ObservableQueueDrain;
import io.reactivex.internal.util.QueueDrainHelper;

public abstract class QueueDrainObserver<T, U, V>
extends QueueDrainSubscriberPad2
implements Observer<T>,
ObservableQueueDrain<U, V> {
    protected final Observer<? super V> actual;
    public final SimplePlainQueue<U> queue;
    public volatile boolean cancelled;
    protected volatile boolean done;
    protected Throwable error;

    public QueueDrainObserver(Observer<? super V> actual, SimplePlainQueue<U> queue) {
        this.actual = actual;
        this.queue = queue;
    }

    @Override
    public final boolean cancelled() {
        return this.cancelled;
    }

    @Override
    public final boolean done() {
        return this.done;
    }

    @Override
    public final boolean enter() {
        return this.wip.getAndIncrement() == 0;
    }

    public final boolean fastEnter() {
        return this.wip.get() == 0 && this.wip.compareAndSet(0, 1);
    }

    protected final void fastPathEmit(U value, boolean delayError, Disposable dispose) {
        Observer<? super V> s2 = this.actual;
        SimplePlainQueue<U> q2 = this.queue;
        if (this.wip.get() == 0 && this.wip.compareAndSet(0, 1)) {
            this.accept(s2, value);
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            q2.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainLoop(q2, s2, delayError, dispose, this);
    }

    public final void fastPathOrderedEmit(U value, boolean delayError, Disposable disposable) {
        Observer<? super V> s2 = this.actual;
        SimplePlainQueue<U> q2 = this.queue;
        if (this.wip.get() == 0 && this.wip.compareAndSet(0, 1)) {
            if (q2.isEmpty()) {
                this.accept(s2, value);
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                q2.offer(value);
            }
        } else {
            q2.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainLoop(q2, s2, delayError, disposable, this);
    }

    @Override
    public final Throwable error() {
        return this.error;
    }

    @Override
    public final int leave(int m2) {
        return this.wip.addAndGet(m2);
    }

    @Override
    public void accept(Observer<? super V> a2, U v2) {
    }
}

