/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.CompletableObserver;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class CompletableDisposeOn$CompletableObserverImplementation
implements CompletableObserver,
Disposable,
Runnable {
    final CompletableObserver s;
    final Scheduler scheduler;
    Disposable d;
    volatile boolean disposed;

    CompletableDisposeOn$CompletableObserverImplementation(CompletableObserver s2, Scheduler scheduler) {
        this.s = s2;
        this.scheduler = scheduler;
    }

    @Override
    public void onComplete() {
        if (this.disposed) {
            return;
        }
        this.s.onComplete();
    }

    @Override
    public void onError(Throwable e2) {
        if (this.disposed) {
            RxJavaPlugins.onError(e2);
            return;
        }
        this.s.onError(e2);
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.s.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.scheduler.scheduleDirect(this);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void run() {
        this.d.dispose();
        this.d = DisposableHelper.DISPOSED;
    }
}

