/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.completable.CompletableMergeDelayErrorArray$MergeInnerCompletableObserver;
import io.reactivex.internal.util.AtomicThrowable;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeDelayErrorIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableMergeDelayErrorIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver s2) {
        Iterator<? extends CompletableSource> iterator;
        CompositeDisposable set = new CompositeDisposable();
        s2.onSubscribe(set);
        try {
            iterator = ObjectHelper.requireNonNull(this.sources.iterator(), "The source iterator returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            s2.onError(e2);
            return;
        }
        AtomicInteger wip = new AtomicInteger(1);
        AtomicThrowable error = new AtomicThrowable();
        while (true) {
            CompletableSource c2;
            boolean b2;
            if (set.isDisposed()) {
                return;
            }
            try {
                b2 = iterator.hasNext();
            }
            catch (Throwable e3) {
                Exceptions.throwIfFatal(e3);
                error.addThrowable(e3);
                break;
            }
            if (!b2) break;
            if (set.isDisposed()) {
                return;
            }
            try {
                c2 = ObjectHelper.requireNonNull(iterator.next(), "The iterator returned a null CompletableSource");
            }
            catch (Throwable e4) {
                Exceptions.throwIfFatal(e4);
                error.addThrowable(e4);
                break;
            }
            if (set.isDisposed()) {
                return;
            }
            wip.getAndIncrement();
            c2.subscribe(new CompletableMergeDelayErrorArray$MergeInnerCompletableObserver(s2, set, error, wip));
        }
        if (wip.decrementAndGet() == 0) {
            Throwable ex2 = error.terminate();
            if (ex2 == null) {
                s2.onComplete();
            } else {
                s2.onError(ex2);
            }
        }
    }
}

