/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.completable.CompletableMergeIterable$MergeCompletableObserver;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableMergeIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver s2) {
        Iterator<? extends CompletableSource> iterator;
        CompositeDisposable set = new CompositeDisposable();
        s2.onSubscribe(set);
        try {
            iterator = ObjectHelper.requireNonNull(this.sources.iterator(), "The source iterator returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            s2.onError(e2);
            return;
        }
        AtomicInteger wip = new AtomicInteger(1);
        CompletableMergeIterable$MergeCompletableObserver shared = new CompletableMergeIterable$MergeCompletableObserver(s2, set, wip);
        while (true) {
            CompletableSource c2;
            boolean b2;
            if (set.isDisposed()) {
                return;
            }
            try {
                b2 = iterator.hasNext();
            }
            catch (Throwable e3) {
                Exceptions.throwIfFatal(e3);
                set.dispose();
                shared.onError(e3);
                return;
            }
            if (!b2) break;
            if (set.isDisposed()) {
                return;
            }
            try {
                c2 = ObjectHelper.requireNonNull(iterator.next(), "The iterator returned a null CompletableSource");
            }
            catch (Throwable e4) {
                Exceptions.throwIfFatal(e4);
                set.dispose();
                shared.onError(e4);
                return;
            }
            if (set.isDisposed()) {
                return;
            }
            wip.getAndIncrement();
            c2.subscribe(shared);
        }
        shared.onComplete();
    }
}

