/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BlockingHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class BlockingFlowableIterable$BlockingFlowableIterator<T>
extends AtomicReference<Yy>
implements FlowableSubscriber<T>,
Disposable,
Runnable,
Iterator<T> {
    private static final long serialVersionUID = 6695226475494099826L;
    final SpscArrayQueue<T> queue;
    final long batchSize;
    final long limit;
    final Lock lock;
    final Condition condition;
    long produced;
    volatile boolean done;
    Throwable error;

    BlockingFlowableIterable$BlockingFlowableIterator(int batchSize) {
        this.queue = new SpscArrayQueue(batchSize);
        this.batchSize = batchSize;
        this.limit = batchSize - (batchSize >> 2);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    @Override
    public boolean hasNext() {
        block5: while (true) {
            boolean d2 = this.done;
            boolean empty = this.queue.isEmpty();
            if (d2) {
                Throwable e2 = this.error;
                if (e2 != null) {
                    throw ExceptionHelper.wrapOrThrow(e2);
                }
                if (empty) {
                    return false;
                }
            }
            if (!empty) break;
            BlockingHelper.verifyNonBlocking();
            this.lock.lock();
            try {
                while (true) {
                    if (this.done || !this.queue.isEmpty()) continue block5;
                    this.condition.await();
                }
            }
            catch (InterruptedException ex2) {
                this.run();
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return true;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T v2 = this.queue.poll();
            long p2 = this.produced + 1L;
            if (p2 == this.limit) {
                this.produced = 0L;
                ((Yy)this.get()).request(p2);
            } else {
                this.produced = p2;
            }
            return v2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this, s2)) {
            s2.request(this.batchSize);
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.queue.offer(t2)) {
            SubscriptionHelper.cancel(this);
            this.onError(new MissingBackpressureException("Queue full?!"));
        } else {
            this.signalConsumer();
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        this.signalConsumer();
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.signalConsumer();
    }

    void signalConsumer() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void run() {
        SubscriptionHelper.cancel(this);
        this.signalConsumer();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this);
    }

    @Override
    public boolean isDisposed() {
        return SubscriptionHelper.isCancelled((Yy)this.get());
    }
}

