/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableBufferBoundarySupplier$BufferBoundarySubscriber;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableBufferBoundarySupplier$BufferBoundarySupplierSubscriber<T, U extends Collection<? super T>, B>
extends QueueDrainSubscriber<T, U, U>
implements Yy,
FlowableSubscriber<T>,
Disposable {
    final Callable<U> bufferSupplier;
    final Callable<? extends Yw<B>> boundarySupplier;
    Yy s;
    final AtomicReference<Disposable> other = new AtomicReference();
    U buffer;

    FlowableBufferBoundarySupplier$BufferBoundarySupplierSubscriber(Yx<? super U> actual, Callable<U> bufferSupplier, Callable<? extends Yw<B>> boundarySupplier) {
        super(actual, new MpscLinkedQueue());
        this.bufferSupplier = bufferSupplier;
        this.boundarySupplier = boundarySupplier;
    }

    @Override
    public void onSubscribe(Yy s2) {
        Yw<B> boundary;
        Collection b2;
        if (!SubscriptionHelper.validate(this.s, s2)) {
            return;
        }
        this.s = s2;
        Yx actual = this.actual;
        try {
            b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.cancelled = true;
            s2.cancel();
            EmptySubscription.error(e2, actual);
            return;
        }
        this.buffer = b2;
        try {
            boundary = ObjectHelper.requireNonNull(this.boundarySupplier.call(), "The boundary publisher supplied is null");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.cancelled = true;
            s2.cancel();
            EmptySubscription.error(ex2, actual);
            return;
        }
        FlowableBufferBoundarySupplier$BufferBoundarySubscriber bs2 = new FlowableBufferBoundarySupplier$BufferBoundarySubscriber(this);
        this.other.set(bs2);
        actual.onSubscribe(this);
        if (!this.cancelled) {
            s2.request(Long.MAX_VALUE);
            boundary.subscribe(bs2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        FlowableBufferBoundarySupplier$BufferBoundarySupplierSubscriber flowableBufferBoundarySupplier$BufferBoundarySupplierSubscriber = this;
        synchronized (flowableBufferBoundarySupplier$BufferBoundarySupplierSubscriber) {
            U b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            b2.add(t2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.cancel();
        this.actual.onError(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        U b2;
        FlowableBufferBoundarySupplier$BufferBoundarySupplierSubscriber flowableBufferBoundarySupplier$BufferBoundarySupplierSubscriber = this;
        synchronized (flowableBufferBoundarySupplier$BufferBoundarySupplierSubscriber) {
            b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            this.buffer = null;
        }
        this.queue.offer(b2);
        this.done = true;
        if (this.enter()) {
            QueueDrainHelper.drainMaxLoop(this.queue, this.actual, false, this, this);
        }
    }

    @Override
    public void request(long n2) {
        this.requested(n2);
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.cancel();
            this.disposeOther();
            if (this.enter()) {
                this.queue.clear();
            }
        }
    }

    void disposeOther() {
        DisposableHelper.dispose(this.other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void next() {
        U b2;
        Yw<B> boundary;
        Collection next;
        try {
            next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.cancel();
            this.actual.onError(e2);
            return;
        }
        try {
            boundary = ObjectHelper.requireNonNull(this.boundarySupplier.call(), "The boundary publisher supplied is null");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.cancelled = true;
            this.s.cancel();
            this.actual.onError(ex2);
            return;
        }
        FlowableBufferBoundarySupplier$BufferBoundarySubscriber bs2 = new FlowableBufferBoundarySupplier$BufferBoundarySubscriber(this);
        Disposable o2 = this.other.get();
        if (!this.other.compareAndSet(o2, bs2)) {
            return;
        }
        FlowableBufferBoundarySupplier$BufferBoundarySupplierSubscriber flowableBufferBoundarySupplier$BufferBoundarySupplierSubscriber = this;
        synchronized (flowableBufferBoundarySupplier$BufferBoundarySupplierSubscriber) {
            b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            this.buffer = next;
        }
        boundary.subscribe(bs2);
        this.fastPathEmitMax(b2, false, this);
    }

    @Override
    public void dispose() {
        this.s.cancel();
        this.disposeOther();
    }

    @Override
    public boolean isDisposed() {
        return this.other.get() == DisposableHelper.DISPOSED;
    }

    @Override
    public boolean accept(Yx<? super U> a2, U v2) {
        this.actual.onNext(v2);
        return true;
    }
}

