/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.operators.flowable.FlowableCache$ReplaySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.LinkedArrayList;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableCache$CacheState<T>
extends LinkedArrayList
implements FlowableSubscriber<T> {
    final Flowable<T> source;
    final AtomicReference<Yy> connection = new AtomicReference();
    final AtomicReference<FlowableCache$ReplaySubscription<T>[]> subscribers;
    static final FlowableCache$ReplaySubscription[] EMPTY = new FlowableCache$ReplaySubscription[0];
    static final FlowableCache$ReplaySubscription[] TERMINATED = new FlowableCache$ReplaySubscription[0];
    volatile boolean isConnected;
    boolean sourceDone;

    FlowableCache$CacheState(Flowable<T> source, int capacityHint) {
        super(capacityHint);
        this.source = source;
        this.subscribers = new AtomicReference<FlowableCache$ReplaySubscription[]>(EMPTY);
    }

    public void addChild(FlowableCache$ReplaySubscription<T> p2) {
        FlowableCache$ReplaySubscription[] b2;
        FlowableCache$ReplaySubscription<T>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == TERMINATED) {
                return;
            }
            int n2 = a2.length;
            b2 = new FlowableCache$ReplaySubscription[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = p2;
        } while (!this.subscribers.compareAndSet(a2, b2));
    }

    public void removeChild(FlowableCache$ReplaySubscription<T> p2) {
        FlowableCache$ReplaySubscription[] b2;
        FlowableCache$ReplaySubscription<T>[] a2;
        do {
            int n2;
            if ((n2 = (a2 = this.subscribers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!a2[i2].equals(p2)) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new FlowableCache$ReplaySubscription[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.subscribers.compareAndSet(a2, b2));
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this.connection, s2)) {
            s2.request(Long.MAX_VALUE);
        }
    }

    public void connect() {
        this.source.subscribe(this);
        this.isConnected = true;
    }

    @Override
    public void onNext(T t2) {
        if (!this.sourceDone) {
            Object o2 = NotificationLite.next(t2);
            this.add(o2);
            for (FlowableCache$ReplaySubscription<T> rp2 : this.subscribers.get()) {
                rp2.replay();
            }
        }
    }

    @Override
    public void onError(Throwable e2) {
        if (!this.sourceDone) {
            this.sourceDone = true;
            Object o2 = NotificationLite.error(e2);
            this.add(o2);
            SubscriptionHelper.cancel(this.connection);
            for (FlowableCache$ReplaySubscription rp2 : this.subscribers.getAndSet(TERMINATED)) {
                rp2.replay();
            }
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        if (!this.sourceDone) {
            this.sourceDone = true;
            Object o2 = NotificationLite.complete();
            this.add(o2);
            SubscriptionHelper.cancel(this.connection);
            for (FlowableCache$ReplaySubscription rp2 : this.subscribers.getAndSet(TERMINATED)) {
                rp2.replay();
            }
        }
    }
}

