/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.internal.operators.flowable.FlowableCache$CacheState;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.NotificationLite;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableCache$ReplaySubscription<T>
extends AtomicInteger
implements Yy {
    private static final long serialVersionUID = -2557562030197141021L;
    private static final long CANCELLED = -1L;
    final Yx<? super T> child;
    final FlowableCache$CacheState<T> state;
    final AtomicLong requested;
    Object[] currentBuffer;
    int currentIndexInBuffer;
    int index;

    FlowableCache$ReplaySubscription(Yx<? super T> child, FlowableCache$CacheState<T> state) {
        this.child = child;
        this.state = state;
        this.requested = new AtomicLong();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            long u2;
            long r2;
            do {
                if ((r2 = this.requested.get()) != -1L) continue;
                return;
            } while (!this.requested.compareAndSet(r2, u2 = BackpressureHelper.addCap(r2, n2)));
            this.replay();
            return;
        }
    }

    @Override
    public void cancel() {
        if (this.requested.getAndSet(-1L) != -1L) {
            this.state.removeChild(this);
        }
    }

    public void replay() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Yx<T> child = this.child;
        AtomicLong rq2 = this.requested;
        do {
            Object o2;
            long r2;
            if ((r2 = rq2.get()) < 0L) {
                return;
            }
            int s2 = this.state.size();
            if (s2 == 0) continue;
            Object[] b2 = this.currentBuffer;
            if (b2 == null) {
                this.currentBuffer = b2 = this.state.head();
            }
            int n2 = b2.length - 1;
            int j2 = this.index;
            int k2 = this.currentIndexInBuffer;
            int valuesProduced = 0;
            while (j2 < s2 && r2 > 0L) {
                if (rq2.get() == -1L) {
                    return;
                }
                if (k2 == n2) {
                    b2 = (Object[])b2[n2];
                    k2 = 0;
                }
                if (NotificationLite.accept(o2 = b2[k2], child)) {
                    return;
                }
                ++k2;
                ++j2;
                --r2;
                ++valuesProduced;
            }
            if (rq2.get() == -1L) {
                return;
            }
            if (r2 == 0L) {
                o2 = b2[k2];
                if (NotificationLite.isComplete(o2)) {
                    child.onComplete();
                    return;
                }
                if (NotificationLite.isError(o2)) {
                    child.onError(NotificationLite.getError(o2));
                    return;
                }
            }
            if (valuesProduced != 0) {
                BackpressureHelper.producedCancel(rq2, valuesProduced);
            }
            this.index = j2;
            this.currentIndexInBuffer = k2;
            this.currentBuffer = b2;
        } while ((missed = this.addAndGet(-missed)) != 0);
    }
}

