/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.functions.BiConsumer;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.FuseToFlowable;
import io.reactivex.internal.operators.flowable.FlowableCollect;
import io.reactivex.internal.operators.flowable.FlowableCollectSingle$CollectSubscriber;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class FlowableCollectSingle<T, U>
extends Single<U>
implements FuseToFlowable<U> {
    final Flowable<T> source;
    final Callable<? extends U> initialSupplier;
    final BiConsumer<? super U, ? super T> collector;

    public FlowableCollectSingle(Flowable<T> source, Callable<? extends U> initialSupplier, BiConsumer<? super U, ? super T> collector) {
        this.source = source;
        this.initialSupplier = initialSupplier;
        this.collector = collector;
    }

    @Override
    public void subscribeActual(SingleObserver<? super U> s2) {
        U u2;
        try {
            u2 = ObjectHelper.requireNonNull(this.initialSupplier.call(), "The initialSupplier returned a null value");
        }
        catch (Throwable e2) {
            EmptyDisposable.error(e2, s2);
            return;
        }
        this.source.subscribe(new FlowableCollectSingle$CollectSubscriber<T, U>(s2, u2, this.collector));
    }

    @Override
    public Flowable<U> fuseToFlowable() {
        return RxJavaPlugins.onAssembly(new FlowableCollect<T, U>(this.source, this.initialSupplier, this.collector));
    }
}

