/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableCombineLatest$CombineLatestInnerSubscriber;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableCombineLatest$CombineLatestCoordinator<T, R>
extends BasicIntQueueSubscription<R> {
    private static final long serialVersionUID = -5082275438355852221L;
    final Yx<? super R> actual;
    final Function<? super Object[], ? extends R> combiner;
    final FlowableCombineLatest$CombineLatestInnerSubscriber<T>[] subscribers;
    final SpscLinkedArrayQueue<Object> queue;
    final Object[] latest;
    final boolean delayErrors;
    boolean outputFused;
    int nonEmptySources;
    int completedSources;
    volatile boolean cancelled;
    final AtomicLong requested;
    volatile boolean done;
    final AtomicReference<Throwable> error;

    FlowableCombineLatest$CombineLatestCoordinator(Yx<? super R> actual, Function<? super Object[], ? extends R> combiner, int n2, int bufferSize, boolean delayErrors) {
        this.actual = actual;
        this.combiner = combiner;
        FlowableCombineLatest$CombineLatestInnerSubscriber[] a2 = new FlowableCombineLatest$CombineLatestInnerSubscriber[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            a2[i2] = new FlowableCombineLatest$CombineLatestInnerSubscriber(this, i2, bufferSize);
        }
        this.subscribers = a2;
        this.latest = new Object[n2];
        this.queue = new SpscLinkedArrayQueue(bufferSize);
        this.requested = new AtomicLong();
        this.error = new AtomicReference();
        this.delayErrors = delayErrors;
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.cancelAll();
    }

    void subscribe(Yw<? extends T>[] sources, int n2) {
        FlowableCombineLatest$CombineLatestInnerSubscriber<T>[] a2 = this.subscribers;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.done || this.cancelled) {
                return;
            }
            sources[i2].subscribe(a2[i2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void innerValue(int index, T value) {
        boolean replenishInsteadOfDrain;
        FlowableCombineLatest$CombineLatestCoordinator flowableCombineLatest$CombineLatestCoordinator = this;
        synchronized (flowableCombineLatest$CombineLatestCoordinator) {
            Object[] os2 = this.latest;
            int localNonEmptySources = this.nonEmptySources;
            if (os2[index] == null) {
                this.nonEmptySources = ++localNonEmptySources;
            }
            os2[index] = value;
            if (os2.length == localNonEmptySources) {
                this.queue.offer(this.subscribers[index], os2.clone());
                replenishInsteadOfDrain = false;
            } else {
                replenishInsteadOfDrain = true;
            }
        }
        if (replenishInsteadOfDrain) {
            this.subscribers[index].requestOne();
        } else {
            this.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void innerComplete(int index) {
        FlowableCombineLatest$CombineLatestCoordinator flowableCombineLatest$CombineLatestCoordinator = this;
        synchronized (flowableCombineLatest$CombineLatestCoordinator) {
            Object[] os2 = this.latest;
            if (os2[index] != null) {
                int localCompletedSources = this.completedSources + 1;
                if (localCompletedSources != os2.length) {
                    this.completedSources = localCompletedSources;
                    return;
                }
                this.done = true;
            } else {
                this.done = true;
            }
        }
        this.drain();
    }

    void innerError(int index, Throwable e2) {
        if (ExceptionHelper.addThrowable(this.error, e2)) {
            if (!this.delayErrors) {
                this.cancelAll();
                this.done = true;
                this.drain();
            } else {
                this.innerComplete(index);
            }
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    void drainOutput() {
        Yx<R> a2 = this.actual;
        SpscLinkedArrayQueue<Object> q2 = this.queue;
        int missed = 1;
        do {
            if (this.cancelled) {
                q2.clear();
                return;
            }
            Throwable ex2 = this.error.get();
            if (ex2 != null) {
                q2.clear();
                a2.onError(ex2);
                return;
            }
            boolean d2 = this.done;
            boolean empty = q2.isEmpty();
            if (!empty) {
                a2.onNext(null);
            }
            if (!d2 || !empty) continue;
            a2.onComplete();
            return;
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    void drainAsync() {
        Yx<R> a2 = this.actual;
        SpscLinkedArrayQueue<Object> q2 = this.queue;
        int missed = 1;
        do {
            long e2;
            long r2 = this.requested.get();
            for (e2 = 0L; e2 != r2; ++e2) {
                R w2;
                boolean empty;
                boolean d2 = this.done;
                Object v2 = q2.poll();
                boolean bl2 = empty = v2 == null;
                if (this.checkTerminated(d2, empty, a2, q2)) {
                    return;
                }
                if (empty) break;
                Object[] va2 = (Object[])q2.poll();
                try {
                    w2 = ObjectHelper.requireNonNull(this.combiner.apply((Object[])va2), "The combiner returned a null value");
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.cancelAll();
                    ExceptionHelper.addThrowable(this.error, ex2);
                    ex2 = ExceptionHelper.terminate(this.error);
                    a2.onError(ex2);
                    return;
                }
                a2.onNext(w2);
                ((FlowableCombineLatest$CombineLatestInnerSubscriber)v2).requestOne();
            }
            if (e2 == r2 && this.checkTerminated(this.done, q2.isEmpty(), a2, q2)) {
                return;
            }
            if (e2 == 0L || r2 == Long.MAX_VALUE) continue;
            this.requested.addAndGet(-e2);
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        if (this.outputFused) {
            this.drainOutput();
        } else {
            this.drainAsync();
        }
    }

    boolean checkTerminated(boolean d2, boolean empty, Yx<?> a2, SpscLinkedArrayQueue<?> q2) {
        if (this.cancelled) {
            this.cancelAll();
            q2.clear();
            return true;
        }
        if (d2) {
            if (this.delayErrors) {
                if (empty) {
                    this.cancelAll();
                    Throwable e2 = ExceptionHelper.terminate(this.error);
                    if (e2 != null && e2 != ExceptionHelper.TERMINATED) {
                        a2.onError(e2);
                    } else {
                        a2.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable e3 = ExceptionHelper.terminate(this.error);
                if (e3 != null && e3 != ExceptionHelper.TERMINATED) {
                    this.cancelAll();
                    q2.clear();
                    a2.onError(e3);
                    return true;
                }
                if (empty) {
                    this.cancelAll();
                    a2.onComplete();
                    return true;
                }
            }
        }
        return false;
    }

    void cancelAll() {
        for (FlowableCombineLatest$CombineLatestInnerSubscriber<T> inner : this.subscribers) {
            inner.cancel();
        }
    }

    @Override
    public int requestFusion(int requestedMode) {
        if ((requestedMode & 4) != 0) {
            return 0;
        }
        int m2 = requestedMode & 2;
        this.outputFused = m2 != 0;
        return m2;
    }

    @Override
    @Nullable
    public R poll() {
        Object e2 = this.queue.poll();
        if (e2 == null) {
            return null;
        }
        Object[] a2 = (Object[])this.queue.poll();
        R r2 = ObjectHelper.requireNonNull(this.combiner.apply((Object[])a2), "The combiner returned a null value");
        ((FlowableCombineLatest$CombineLatestInnerSubscriber)e2).requestOne();
        return r2;
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

