/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableCombineLatest$CombineLatestCoordinator;
import io.reactivex.internal.operators.flowable.FlowableCombineLatest$SingletonArrayFunc;
import io.reactivex.internal.operators.flowable.FlowableMap$MapSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Iterator;

public final class FlowableCombineLatest<T, R>
extends Flowable<R> {
    @Nullable
    final Yw<? extends T>[] array;
    @Nullable
    final Iterable<? extends Yw<? extends T>> iterable;
    final Function<? super Object[], ? extends R> combiner;
    final int bufferSize;
    final boolean delayErrors;

    public FlowableCombineLatest(@NonNull Yw<? extends T>[] array, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize, boolean delayErrors) {
        this.array = array;
        this.iterable = null;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    public FlowableCombineLatest(@NonNull Iterable<? extends Yw<? extends T>> iterable, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize, boolean delayErrors) {
        this.array = null;
        this.iterable = iterable;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribeActual(Yx<? super R> s2) {
        int n2;
        Yw<? extends T>[] a2;
        block11: {
            a2 = this.array;
            if (a2 == null) {
                Iterator<Yw<T>> it2;
                n2 = 0;
                a2 = new Yw[8];
                try {
                    it2 = ObjectHelper.requireNonNull(this.iterable.iterator(), "The iterator returned is null");
                }
                catch (Throwable e2) {
                    Exceptions.throwIfFatal(e2);
                    EmptySubscription.error(e2, s2);
                    return;
                }
                while (true) {
                    Yw<? extends T> p2;
                    boolean b2;
                    try {
                        b2 = it2.hasNext();
                    }
                    catch (Throwable e3) {
                        Exceptions.throwIfFatal(e3);
                        EmptySubscription.error(e3, s2);
                        return;
                    }
                    if (!b2) break block11;
                    try {
                        p2 = ObjectHelper.requireNonNull(it2.next(), "The publisher returned by the iterator is null");
                    }
                    catch (Throwable e4) {
                        Exceptions.throwIfFatal(e4);
                        EmptySubscription.error(e4, s2);
                        return;
                    }
                    if (n2 == a2.length) {
                        Yw[] c2 = new Yw[n2 + (n2 >> 2)];
                        System.arraycopy(a2, 0, c2, 0, n2);
                        a2 = c2;
                    }
                    a2[n2++] = p2;
                }
            }
            n2 = a2.length;
        }
        if (n2 == 0) {
            EmptySubscription.complete(s2);
            return;
        }
        if (n2 == 1) {
            a2[0].subscribe(new FlowableMap$MapSubscriber(s2, new FlowableCombineLatest$SingletonArrayFunc(this)));
            return;
        }
        FlowableCombineLatest$CombineLatestCoordinator<? extends T, R> coordinator = new FlowableCombineLatest$CombineLatestCoordinator<T, R>(s2, this.combiner, n2, this.bufferSize, this.delayErrors);
        s2.onSubscribe(coordinator);
        coordinator.subscribe(a2, n2);
    }
}

