/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableEmitter;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Cancellable;
import io.reactivex.internal.disposables.CancellableDisposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.operators.flowable.FlowableCreate$SerializedEmitter;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;

abstract class FlowableCreate$BaseEmitter<T>
extends AtomicLong
implements Yy,
FlowableEmitter<T> {
    private static final long serialVersionUID = 7326289992464377023L;
    final Yx<? super T> actual;
    final SequentialDisposable serial;

    FlowableCreate$BaseEmitter(Yx<? super T> actual) {
        this.actual = actual;
        this.serial = new SequentialDisposable();
    }

    @Override
    public void onComplete() {
        this.complete();
    }

    protected void complete() {
        if (this.isCancelled()) {
            return;
        }
        try {
            this.actual.onComplete();
        }
        finally {
            this.serial.dispose();
        }
    }

    @Override
    public final void onError(Throwable e2) {
        if (!this.tryOnError(e2)) {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public boolean tryOnError(Throwable e2) {
        return this.error(e2);
    }

    protected boolean error(Throwable e2) {
        if (e2 == null) {
            e2 = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        if (this.isCancelled()) {
            return false;
        }
        try {
            this.actual.onError(e2);
        }
        finally {
            this.serial.dispose();
        }
        return true;
    }

    @Override
    public final void cancel() {
        this.serial.dispose();
        this.onUnsubscribed();
    }

    void onUnsubscribed() {
    }

    @Override
    public final boolean isCancelled() {
        return this.serial.isDisposed();
    }

    @Override
    public final void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this, n2);
            this.onRequested();
        }
    }

    void onRequested() {
    }

    @Override
    public final void setDisposable(Disposable s2) {
        this.serial.update(s2);
    }

    @Override
    public final void setCancellable(Cancellable c2) {
        this.setDisposable(new CancellableDisposable(c2));
    }

    @Override
    public final long requested() {
        return this.get();
    }

    @Override
    public final FlowableEmitter<T> serialize() {
        return new FlowableCreate$SerializedEmitter(this);
    }
}

