/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableDebounce$DebounceSubscriber$DebounceInnerSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableDebounce$DebounceSubscriber<T, U>
extends AtomicLong
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = 6725975399620862591L;
    final Yx<? super T> actual;
    final Function<? super T, ? extends Yw<U>> debounceSelector;
    Yy s;
    final AtomicReference<Disposable> debouncer = new AtomicReference();
    volatile long index;
    boolean done;

    FlowableDebounce$DebounceSubscriber(Yx<? super T> actual, Function<? super T, ? extends Yw<U>> debounceSelector) {
        this.actual = actual;
        this.debounceSelector = debounceSelector;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        Yw<U> p2;
        long idx;
        if (this.done) {
            return;
        }
        this.index = idx = this.index + 1L;
        Disposable d2 = this.debouncer.get();
        if (d2 != null) {
            d2.dispose();
        }
        try {
            p2 = ObjectHelper.requireNonNull(this.debounceSelector.apply(t2), "The publisher supplied is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.cancel();
            this.actual.onError(e2);
            return;
        }
        FlowableDebounce$DebounceSubscriber$DebounceInnerSubscriber dis = new FlowableDebounce$DebounceSubscriber$DebounceInnerSubscriber(this, idx, t2);
        if (this.debouncer.compareAndSet(d2, dis)) {
            p2.subscribe(dis);
        }
    }

    @Override
    public void onError(Throwable t2) {
        DisposableHelper.dispose(this.debouncer);
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Disposable d2 = this.debouncer.get();
        if (!DisposableHelper.isDisposed(d2)) {
            FlowableDebounce$DebounceSubscriber$DebounceInnerSubscriber dis = (FlowableDebounce$DebounceSubscriber$DebounceInnerSubscriber)d2;
            dis.emit();
            DisposableHelper.dispose(this.debouncer);
            this.actual.onComplete();
        }
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this, n2);
        }
    }

    @Override
    public void cancel() {
        this.s.cancel();
        DisposableHelper.dispose(this.debouncer);
    }

    void emit(long idx, T value) {
        if (idx == this.index) {
            long r2 = this.get();
            if (r2 != 0L) {
                this.actual.onNext(value);
                BackpressureHelper.produced(this, 1L);
            } else {
                this.cancel();
                this.actual.onError(new MissingBackpressureException("Could not deliver value due to lack of requests"));
            }
        }
    }
}

