/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableDistinct$DistinctSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Collection;
import java.util.concurrent.Callable;

public final class FlowableDistinct<T, K>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super T, K> keySelector;
    final Callable<? extends Collection<? super K>> collectionSupplier;

    public FlowableDistinct(Flowable<T> source, Function<? super T, K> keySelector, Callable<? extends Collection<? super K>> collectionSupplier) {
        super(source);
        this.keySelector = keySelector;
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    public void subscribeActual(Yx<? super T> observer) {
        Collection<? super K> collection;
        try {
            collection = ObjectHelper.requireNonNull(this.collectionSupplier.call(), "The collectionSupplier returned a null collection. Null values are generally not allowed in 2.x operators and sources.");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            EmptySubscription.error(ex2, observer);
            return;
        }
        this.source.subscribe(new FlowableDistinct$DistinctSubscriber<T, K>(observer, this.keySelector, collection));
    }
}

