/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.annotations.Nullable;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Function;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscribers.BasicFuseableSubscriber;

final class FlowableDistinctUntilChanged$DistinctUntilChangedSubscriber<T, K>
extends BasicFuseableSubscriber<T, T>
implements ConditionalSubscriber<T> {
    final Function<? super T, K> keySelector;
    final BiPredicate<? super K, ? super K> comparer;
    K last;
    boolean hasValue;

    FlowableDistinctUntilChanged$DistinctUntilChangedSubscriber(Yx<? super T> actual, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
        super(actual);
        this.keySelector = keySelector;
        this.comparer = comparer;
    }

    @Override
    public void onNext(T t2) {
        if (!this.tryOnNext(t2)) {
            this.s.request(1L);
        }
    }

    @Override
    public boolean tryOnNext(T t2) {
        if (this.done) {
            return false;
        }
        if (this.sourceMode != 0) {
            this.actual.onNext(t2);
            return true;
        }
        try {
            K key = this.keySelector.apply(t2);
            if (this.hasValue) {
                boolean equal = this.comparer.test(this.last, key);
                this.last = key;
                if (equal) {
                    return false;
                }
            } else {
                this.hasValue = true;
                this.last = key;
            }
        }
        catch (Throwable ex2) {
            this.fail(ex2);
            return true;
        }
        this.actual.onNext(t2);
        return true;
    }

    @Override
    public int requestFusion(int mode) {
        return this.transitiveBoundaryFusion(mode);
    }

    @Override
    @Nullable
    public T poll() {
        Object v2;
        while ((v2 = this.qs.poll()) != null) {
            K key = this.keySelector.apply(v2);
            if (!this.hasValue) {
                this.hasValue = true;
                this.last = key;
                return v2;
            }
            if (!this.comparer.test(this.last, key)) {
                this.last = key;
                return v2;
            }
            this.last = key;
            if (this.sourceMode == 1) continue;
            this.s.request(1L);
        }
        return null;
    }
}

