/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class FlowableDoOnEach$DoOnEachSubscriber<T>
extends BasicFuseableSubscriber<T, T> {
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onAfterTerminate;

    FlowableDoOnEach$DoOnEachSubscriber(Yx<? super T> actual, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
        super(actual);
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onAfterTerminate = onAfterTerminate;
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (this.sourceMode != 0) {
            this.actual.onNext(null);
            return;
        }
        try {
            this.onNext.accept(t2);
        }
        catch (Throwable e2) {
            this.fail(e2);
            return;
        }
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        boolean relay = true;
        try {
            this.onError.accept(t2);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(new CompositeException(t2, e2));
            relay = false;
        }
        if (relay) {
            this.actual.onError(t2);
        }
        try {
            this.onAfterTerminate.run();
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            RxJavaPlugins.onError(e3);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        try {
            this.onComplete.run();
        }
        catch (Throwable e2) {
            this.fail(e2);
            return;
        }
        this.done = true;
        this.actual.onComplete();
        try {
            this.onAfterTerminate.run();
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            RxJavaPlugins.onError(e3);
        }
    }

    @Override
    public int requestFusion(int mode) {
        return this.transitiveBoundaryFusion(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T poll() {
        Object v2;
        block13: {
            try {
                v2 = this.qs.poll();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                try {
                    this.onError.accept(ex2);
                }
                catch (Throwable exc) {
                    throw new CompositeException(ex2, exc);
                }
                throw ExceptionHelper.throwIfThrowable(ex2);
            }
            if (v2 != null) {
                try {
                    try {
                        this.onNext.accept(v2);
                        break block13;
                    }
                    catch (Throwable ex3) {
                        Exceptions.throwIfFatal(ex3);
                        try {
                            this.onError.accept(ex3);
                        }
                        catch (Throwable exc) {
                            throw new CompositeException(ex3, exc);
                        }
                        throw ExceptionHelper.throwIfThrowable(ex3);
                    }
                }
                finally {
                    this.onAfterTerminate.run();
                }
            }
            if (this.sourceMode == 1) {
                this.onComplete.run();
                this.onAfterTerminate.run();
            }
        }
        return v2;
    }
}

